/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.TransitionModel;

final class EmptyTransitionModel
implements TransitionHistory,
Serializable {
    private static final long serialVersionUID = 1374714021808040253L;
    private final ZonalOffset offset;

    EmptyTransitionModel(ZonalOffset zonalOffset) {
        this.offset = zonalOffset;
    }

    @Override
    public ZonalOffset getInitialOffset() {
        return this.offset;
    }

    @Override
    public ZonalTransition getStartTransition(UnixTime unixTime) {
        return null;
    }

    @Override
    public ZonalTransition getNextTransition(UnixTime unixTime) {
        return null;
    }

    @Override
    public ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime) {
        return null;
    }

    @Override
    public List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime) {
        return Collections.singletonList(this.offset);
    }

    @Override
    public List<ZonalTransition> getStdTransitions() {
        return Collections.emptyList();
    }

    @Override
    public List<ZonalTransition> getTransitions(UnixTime unixTime, UnixTime unixTime2) {
        return Collections.emptyList();
    }

    @Override
    public boolean hasNegativeDST() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public void dump(Appendable appendable) throws IOException {
        appendable.append("*** Fixed offset:").append(TransitionModel.NEW_LINE).append(">>> ");
        appendable.append(this.getInitialOffset().canonical()).append(TransitionModel.NEW_LINE);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EmptyTransitionModel) {
            EmptyTransitionModel emptyTransitionModel = (EmptyTransitionModel)object;
            return this.offset.equals(emptyTransitionModel.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.offset.hashCode();
    }

    public String toString() {
        return "EmptyTransitionModel=" + this.offset.canonical();
    }
}

