/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.io.IOException;
import java.text.ParsePosition;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;

public abstract class DualYearOfEraElement<T extends ChronoEntity<T>>
extends StdIntegerDateElement<T>
implements DualFormatElement {
    protected DualYearOfEraElement(Class<T> clazz, int n, int n2, char c) {
        super("YEAR_OF_ERA", clazz, n, n2, c, null, null);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
        int n;
        NumberSystem numberSystem = this.getNumberSystem(attributeQuery);
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.NARROW);
        switch (textWidth) {
            case NARROW: {
                n = 1;
                break;
            }
            case SHORT: {
                n = 2;
                break;
            }
            case ABBREVIATED: {
                n = 3;
                break;
            }
            default: {
                n = 4;
            }
        }
        char c = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        this.print(chronoDisplay, appendable, attributeQuery, numberSystem, c, n, 10);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, NumberSystem numberSystem, char c, int n, int n2) throws IOException, ChronoException {
        int n3 = chronoDisplay.getInt(this);
        String string = numberSystem.toNumeral(n3);
        if (numberSystem.isDecimal()) {
            int n4 = string.length();
            int n5 = n - n4;
            for (int i = 0; i < n5; ++i) {
                appendable.append(c);
            }
        }
        appendable.append(string);
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        int n;
        NumberSystem numberSystem = this.getNumberSystem(attributeQuery);
        int n2 = n = parsePosition.getIndex();
        int n3 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (int)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (int)numberSystem.getDigits().charAt(0) : 48);
        Leniency leniency = numberSystem.isDecimal() ? Leniency.SMART : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        long l = 0L;
        if (numberSystem.isDecimal()) {
            int n4;
            int n5 = Math.min(n2 + 9, charSequence.length());
            for (int i = n2; i < n5 && (n4 = charSequence.charAt(i) - n3) >= 0 && n4 <= 9; ++i) {
                l = l * 10L + (long)n4;
                ++n2;
            }
        } else {
            int n6 = 0;
            int n7 = charSequence.length();
            for (int i = n2; i < n7 && numberSystem.contains(charSequence.charAt(i)); ++i) {
                ++n6;
            }
            if (n6 > 0) {
                l = numberSystem.toInteger(charSequence.subSequence(n2, n2 + n6).toString(), leniency);
                n2 += n6;
            }
        }
        if (n2 == n || l > Integer.MAX_VALUE) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        parsePosition.setIndex(n2);
        return (int)l;
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery, ChronoEntity<?> chronoEntity) {
        return this.parse(charSequence, parsePosition, attributeQuery);
    }

    protected abstract NumberSystem getNumberSystem(AttributeQuery var1);
}

