/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

class AstroUtils {
    AstroUtils() {
    }

    static double gmst(double d) {
        double d2 = Math.floor(d);
        double d3 = 86400.0 * (d - d2);
        double d4 = (d2 - 51544.5) / 36525.0;
        double d5 = (d - 51544.5) / 36525.0;
        double d6 = 24110.54841 + 8640184.812866 * d4 + 1.0027379093 * d3 + (0.093104 - 6.2E-6 * d5) * d5 * d5;
        double d7 = d6 / 86400.0;
        return (d7 - Math.floor(d7)) * 2.0 * Math.PI;
    }

    static double getRefraction(double d) {
        return 1.02 / Math.tan(Math.toRadians(10.3 / (d + 5.11) + d)) + 0.0019279;
    }

    static double refractionFactorOfStdAtmosphere(int n) {
        double d = 1.0 - 0.0065 * (double)n / 288.15;
        return Math.pow(d, 4.255);
    }

    static double toRange_0_360(double d) {
        while (Double.compare(0.0, d) > 0) {
            d += 360.0;
        }
        while (Double.compare(d, 360.0) >= 0) {
            d -= 360.0;
        }
        return d;
    }

    static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }
}

