/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.Moment;
import net.time4j.calendar.EastAsianCS;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.SolarTerm;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.TextElement;

class EastAsianST<D extends EastAsianCalendar<?, D>>
implements TextElement<SolarTerm>,
ElementRule<D, SolarTerm>,
Serializable {
    private static final EastAsianST SINGLETON = new EastAsianST();
    private static final long serialVersionUID = 4572549754637955194L;

    EastAsianST() {
    }

    static <D extends EastAsianCalendar<?, D>> EastAsianST<D> getInstance() {
        return SINGLETON;
    }

    @Override
    public String name() {
        return "SOLAR_TERM";
    }

    @Override
    public Class<SolarTerm> getType() {
        return SolarTerm.class;
    }

    @Override
    public char getSymbol() {
        return '\u0000';
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return chronoDisplay.get(this).compareTo((Enum)chronoDisplay2.get(this));
    }

    @Override
    public SolarTerm getDefaultMinimum() {
        return SolarTerm.MINOR_01_LICHUN_315;
    }

    @Override
    public SolarTerm getDefaultMaximum() {
        return SolarTerm.MAJOR_12_DAHAN_300;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public String getDisplayName(Locale locale) {
        String string = locale.getLanguage();
        if (string.equals("zh")) {
            return locale.getCountry().equals("TW") ? "\u7bc0\u6c23" : "\u8282\u6c14";
        }
        if (string.equals("ko")) {
            return "\uc808\uae30";
        }
        if (string.equals("vi")) {
            return "ti\u1ebft kh\u00ed";
        }
        if (string.equals("ja")) {
            return "\u7bc0\u6c17";
        }
        if (string.isEmpty()) {
            return "jieqi";
        }
        return "ji\u00e9q\u00ec";
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        SolarTerm solarTerm = chronoDisplay.get(this);
        appendable.append(solarTerm.getDisplayName(locale));
    }

    @Override
    public SolarTerm parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        int n = charSequence.length();
        int n2 = parsePosition.getIndex();
        if (n2 >= n) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        return SolarTerm.parse(charSequence, locale, parsePosition);
    }

    @Override
    public SolarTerm getValue(D d) {
        Moment moment = ((EastAsianCalendar)d).getCalendarSystem().midnight(((EastAsianCalendar)d).getDaysSinceEpochUTC() + 1L);
        return SolarTerm.of(moment);
    }

    @Override
    public SolarTerm getMinimum(D d) {
        EastAsianCS eastAsianCS = ((EastAsianCalendar)d).getCalendarSystem();
        long l = eastAsianCS.newYear(((EastAsianCalendar)d).getCycle(), ((EastAsianCalendar)d).getYear().getNumber());
        return SolarTerm.of(eastAsianCS.midnight(l + 1L));
    }

    @Override
    public SolarTerm getMaximum(D d) {
        EastAsianCS eastAsianCS = ((EastAsianCalendar)d).getCalendarSystem();
        long l = eastAsianCS.newYear(((EastAsianCalendar)d).getCycle(), ((EastAsianCalendar)d).getYear().getNumber());
        return SolarTerm.of(eastAsianCS.midnight(l + (long)((EastAsianCalendar)d).lengthOfYear()));
    }

    @Override
    public boolean isValid(D d, SolarTerm solarTerm) {
        return solarTerm != null;
    }

    @Override
    public D withValue(D d, SolarTerm solarTerm, boolean bl) {
        if (solarTerm == null) {
            throw new IllegalArgumentException("Missing solar term.");
        }
        ChronoOperator chronoOperator = solarTerm.sinceNewYear();
        return (D)((EastAsianCalendar)((ChronoEntity)d).with(chronoOperator));
    }

    @Override
    public ChronoElement<?> getChildAtFloor(D d) {
        throw new AbstractMethodError();
    }

    @Override
    public ChronoElement<?> getChildAtCeiling(D d) {
        throw new AbstractMethodError();
    }

    protected Object readResolve() throws ObjectStreamException {
        return SINGLETON;
    }
}

