/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.Moment;
import net.time4j.ZonalClock;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.base.TimeSource;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TickProvider;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class SystemClock
implements TimeSource<Moment> {
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final TickProvider PROVIDER;
    private static final boolean MONOTON_MODE;
    public static final SystemClock INSTANCE;
    public static final SystemClock MONOTONIC;
    private final boolean monotonic;
    private final long offset;

    private SystemClock(boolean bl, long l) {
        this.monotonic = bl;
        this.offset = l;
    }

    @Override
    public Moment currentTime() {
        if ((this.monotonic || MONOTON_MODE) && LeapSeconds.getInstance().isEnabled()) {
            long l = this.utcNanos();
            return Moment.of(MathUtils.floorDivide(l, 1000000000), MathUtils.floorModulo(l, 1000000000), TimeScale.UTC);
        }
        long l = System.currentTimeMillis();
        return Moment.of(MathUtils.floorDivide(l, 1000), MathUtils.floorModulo(l, 1000) * 1000000, TimeScale.POSIX);
    }

    public long currentTimeInMillis() {
        if (this.monotonic || MONOTON_MODE) {
            long l = this.utcNanos();
            long l2 = LeapSeconds.getInstance().strip(MathUtils.floorDivide(l, 1000000000));
            return MathUtils.safeMultiply(l2, 1000L) + (long)MathUtils.floorModulo(l, 1000000);
        }
        return System.currentTimeMillis();
    }

    public long currentTimeInMicros() {
        if (this.monotonic || MONOTON_MODE) {
            long l = this.utcNanos();
            long l2 = LeapSeconds.getInstance().strip(MathUtils.floorDivide(l, 1000000000));
            return MathUtils.safeMultiply(l2, 1000000L) + (long)MathUtils.floorModulo(l, 1000);
        }
        return MathUtils.safeMultiply(System.currentTimeMillis(), 1000L);
    }

    public long realTimeInMicros() {
        if (this.monotonic || MONOTON_MODE) {
            return MathUtils.floorDivide(this.utcNanos(), 1000);
        }
        long l = System.currentTimeMillis();
        long l2 = LeapSeconds.getInstance().enhance(MathUtils.floorDivide(l, 1000));
        return MathUtils.safeMultiply(l2, 1000000L) + (long)(MathUtils.floorModulo(l, 1000) * 1000);
    }

    public static ZonalClock inPlatformView() {
        return new ZonalClock(INSTANCE, Timezone.ofPlatform());
    }

    public static ZonalClock inLocalView() {
        return ZonalClock.ofSystem();
    }

    public static ZonalClock inZonalView(TZID tZID) {
        return new ZonalClock(INSTANCE, tZID);
    }

    public static ZonalClock inZonalView(String string) {
        return new ZonalClock(INSTANCE, string);
    }

    public static Moment currentMoment() {
        return INSTANCE.currentTime();
    }

    public SystemClock recalibrated() {
        return new SystemClock(this.monotonic, SystemClock.calibrate());
    }

    public SystemClock synchronizedWith(TimeSource<?> timeSource) {
        Moment moment = Moment.from(timeSource.currentTime());
        long l = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
        long l2 = moment.getElapsedTime(TimeScale.UTC);
        long l3 = MathUtils.safeMultiply(l2, 1000000000L) + (long)moment.getNanosecond(TimeScale.UTC);
        long l4 = MathUtils.safeSubtract(l3, l);
        return new SystemClock(this.monotonic, l4);
    }

    private static long calibrate() {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        for (int i = 0; i < 10; ++i) {
            l2 = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
            long l3 = System.currentTimeMillis();
            if (l == l3) break;
            l = l3;
        }
        long l4 = LeapSeconds.getInstance().enhance(MathUtils.floorDivide(l, 1000));
        long l5 = MathUtils.safeMultiply(l4, 1000000000L) + (long)(MathUtils.floorModulo(l, 1000) * 1000000);
        return MathUtils.safeSubtract(l5, l2);
    }

    private long utcNanos() {
        long l = MONOTON_MODE ? System.nanoTime() : PROVIDER.getNanos();
        return MathUtils.safeAdd(l, this.offset);
    }

    static {
        String string = System.getProperty("java.vm.name");
        TickProvider tickProvider = null;
        for (TickProvider tickProvider2 : ResourceLoader.getInstance().services(TickProvider.class)) {
            if (!string.equals(tickProvider2.getPlatform())) continue;
            tickProvider = tickProvider2;
            break;
        }
        if (tickProvider == null) {
            tickProvider = new StdTickProvider();
        }
        PROVIDER = tickProvider;
        MONOTON_MODE = Boolean.getBoolean("net.time4j.systemclock.nanoTime");
        INSTANCE = new SystemClock(false, SystemClock.calibrate());
        MONOTONIC = new SystemClock(true, SystemClock.calibrate());
    }

    private static class StdTickProvider
    implements TickProvider {
        private StdTickProvider() {
        }

        @Override
        public String getPlatform() {
            return "";
        }

        @Override
        public long getNanos() {
            return System.nanoTime();
        }
    }
}

