/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.asmx.plus;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.tascalate.asmx.ClassReader;
import net.tascalate.asmx.Type;
import net.tascalate.asmx.plus.ResourceLoader;

public class ClassHierarchy {
    private final ResourceLoader loader;
    private final Map<Key, String> lookupCache;
    private final Map<TypeInfo, Reference<TypeInfo>> typesCache;
    private final TypeInfo OBJECT = new TypeInfo("java/lang/Object", null, null, false){

        @Override
        TypeInfo superClass() {
            return null;
        }

        @Override
        TypeInfo[] interfaces() {
            return EMPTY_TYPE_INFOS;
        }

        @Override
        boolean isSubclassOf(TypeInfo base) {
            return this.equals(base);
        }

        @Override
        List<TypeInfo> flattenHierarchy() {
            return Collections.singletonList(this);
        }

        @Override
        int flattenHierarchy(Queue<TypeInfo> s, SortedSet<InterfaceEntry> i, Set<String> v, int d) {
            return 0;
        }
    };
    static final String[] EMPTY_STRINGS = new String[0];
    static final TypeInfo[] EMPTY_TYPE_INFOS = new TypeInfo[0];
    private final TypeInfo[] SPECIAL_CLASSES = new TypeInfo[]{this.OBJECT, new SpecialInterfaceInfo("java/io/Externalizable", new String[]{"java/io/Serializable"}), new SpecialInterfaceInfo("java/io/Closeable", new String[]{"java/lang/AutoCloseable"}), new SpecialInterfaceInfo("java/io/Serializable", EMPTY_STRINGS), new SpecialInterfaceInfo("java/lang/AutoCloseable", EMPTY_STRINGS), new SpecialInterfaceInfo("java/lang/Cloneable", EMPTY_STRINGS)};

    public ClassHierarchy(ResourceLoader loader) {
        this.loader = loader;
        this.lookupCache = new HashMap<Key, String>();
        this.typesCache = new WeakHashMap<TypeInfo, Reference<TypeInfo>>();
        for (TypeInfo ti : this.SPECIAL_CLASSES) {
            this.typesCache.put(ti, new SoftReference<TypeInfo>(ti));
        }
    }

    private ClassHierarchy(ResourceLoader loader, Map<Key, String> lookupCache, Map<TypeInfo, Reference<TypeInfo>> typesCache) {
        this.loader = loader;
        this.lookupCache = lookupCache;
        this.typesCache = typesCache;
    }

    public ResourceLoader loader() {
        return this.loader;
    }

    public ClassHierarchy shareWith(ResourceLoader resourceLoader) {
        if (resourceLoader == this.loader) {
            return this;
        }
        return new ClassHierarchy(resourceLoader, this.lookupCache, this.typesCache);
    }

    public boolean isSubClass(String type1, String type2) {
        String commonSuperClass = this.getCommonSuperClass(type1, type2);
        return type2.equals(commonSuperClass);
    }

    public boolean isSuperClass(String type1, String type2) {
        return this.isSubClass(type2, type1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCommonSuperClass(String type1, String type2) {
        String result;
        Key key = new Key(type1, type2);
        Map<Key, String> map = this.lookupCache;
        synchronized (map) {
            result = this.lookupCache.get(key);
            if (null == result) {
                result = this.calculateCommonSuperClass(type1, type2);
                this.lookupCache.put(key, result);
            }
        }
        return result;
    }

    public Type getCommonSuperType(Type type1, Type type2) {
        return Type.getObjectType((String)this.getCommonSuperClass(type1.getInternalName(), type2.getInternalName()));
    }

    private String calculateCommonSuperClass(String type1, String type2) {
        try {
            TypeInfo info1 = this.getTypeInfo(type1);
            TypeInfo info2 = this.getTypeInfo(type2);
            if (info1.isSubclassOf(info2)) {
                return type2;
            }
            if (info2.isSubclassOf(info1)) {
                return type1;
            }
            List<TypeInfo> supers1 = info1.flattenHierarchy();
            List<TypeInfo> supers2 = info2.flattenHierarchy();
            for (TypeInfo a : supers1) {
                for (TypeInfo b : supers2) {
                    if (!a.equals(b)) continue;
                    return a.name;
                }
            }
            return this.OBJECT.name;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeInfo getTypeInfo(String type) throws IOException {
        TypeInfo key = new TypeInfo(type, null, null, false);
        Map<TypeInfo, Reference<TypeInfo>> map = this.typesCache;
        synchronized (map) {
            TypeInfo value;
            Reference<TypeInfo> reference = this.typesCache.get(key);
            TypeInfo typeInfo = value = null != reference ? reference.get() : null;
            if (null == value) {
                value = this.loadTypeInfo(type);
                this.typesCache.put(value, new SoftReference<TypeInfo>(value));
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeInfo loadTypeInfo(String type) throws IOException {
        InputStream is = this.loader.getResourceAsStream(type + ".class");
        try {
            ClassReader info = new ClassReader(is);
            TypeInfo typeInfo = new TypeInfo(info.getClassName(), info.getSuperName(), info.getInterfaces(), (info.getAccess() & 0x200) != 0);
            return typeInfo;
        }
        finally {
            is.close();
        }
    }

    private static List<TypeInfo> narrow(SortedSet<InterfaceEntry> entries) {
        int size = entries.size();
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>(size);
        for (InterfaceEntry ie : entries) {
            result.add(ie.typeInfo);
        }
        return result;
    }

    static class SymmetricalPair<T> {
        private final T a;
        private final T b;

        SymmetricalPair(T a, T b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            int hA = null == this.a ? 0 : this.a.hashCode();
            int hB = null == this.b ? 0 : this.b.hashCode();
            return Math.min(hA, hB) * 37 + Math.max(hA, hB);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            SymmetricalPair that = (SymmetricalPair)other;
            return SymmetricalPair.same(this.a, that.a) && SymmetricalPair.same(this.b, that.b) || SymmetricalPair.same(this.a, that.b) && SymmetricalPair.same(this.b, that.a);
        }

        private static <T> boolean same(T a, T b) {
            return a == null ? b == null : a.equals(b);
        }
    }

    static class Key
    extends SymmetricalPair<String> {
        Key(String a, String b) {
            super(a, b);
        }
    }

    static class InterfaceEntry
    implements Comparable<InterfaceEntry> {
        final TypeInfo typeInfo;
        final int strength;
        final int depth;

        InterfaceEntry(TypeInfo typeInfo, int strength, int depth) {
            this.typeInfo = typeInfo;
            this.strength = strength;
            this.depth = depth;
        }

        @Override
        public int compareTo(InterfaceEntry other) {
            int delta = other.strength - this.strength;
            if (delta != 0) {
                return delta;
            }
            delta = this.depth - other.depth;
            if (delta != 0) {
                return delta;
            }
            return this.typeInfo.name.compareTo(other.typeInfo.name);
        }
    }

    class SpecialInterfaceInfo
    extends TypeInfo {
        SpecialInterfaceInfo(String name, String[] interfaceNames) {
            super(name, null, interfaceNames, true);
        }

        @Override
        TypeInfo superClass() {
            return null;
        }

        @Override
        int initialStrength() {
            return 0;
        }
    }

    class TypeInfo {
        final String name;
        final boolean isInterface;
        private String superClassName;
        private TypeInfo superClass;
        private String[] interfaceNames;
        private TypeInfo[] interfaces;

        TypeInfo(String name, String superClassName, String[] interfaceNames, boolean isInterface) {
            this.name = name;
            this.isInterface = isInterface;
            this.superClassName = superClassName;
            this.interfaceNames = null != interfaceNames ? interfaceNames : EMPTY_STRINGS;
        }

        synchronized TypeInfo superClass() throws IOException {
            if (null != this.superClassName) {
                this.superClass = ClassHierarchy.this.getTypeInfo(this.superClassName);
                this.superClassName = null;
            }
            return this.superClass;
        }

        synchronized TypeInfo[] interfaces() throws IOException {
            if (null != this.interfaceNames) {
                int size = this.interfaceNames.length;
                if (size == 0) {
                    this.interfaces = EMPTY_TYPE_INFOS;
                } else {
                    this.interfaces = new TypeInfo[size];
                    for (int i = size - 1; i >= 0; --i) {
                        this.interfaces[i] = ClassHierarchy.this.getTypeInfo(this.interfaceNames[i]);
                    }
                }
                this.interfaceNames = null;
            }
            return this.interfaces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isSubclassOf(TypeInfo base) throws IOException {
            String targetName = base.name;
            if (this.name.equals(targetName)) {
                return true;
            }
            TypeInfo typeInfo = this;
            synchronized (typeInfo) {
                if (!base.isInterface && null != this.superClassName && this.superClassName.equals(targetName)) {
                    return true;
                }
                if (base.isInterface && null != this.interfaceNames) {
                    for (int i = this.interfaceNames.length - 1; i >= 0; --i) {
                        if (!this.interfaceNames[i].equals(targetName)) continue;
                        return true;
                    }
                }
            }
            TypeInfo t = this.superClass();
            if (null != t && t.isSubclassOf(base)) {
                return true;
            }
            if (base.isInterface) {
                TypeInfo[] tt = this.interfaces();
                for (int i = tt.length - 1; i >= 0; --i) {
                    if (!tt[i].isSubclassOf(base)) continue;
                    return true;
                }
            }
            return false;
        }

        List<TypeInfo> flattenHierarchy() throws IOException {
            LinkedList<TypeInfo> superclasses = new LinkedList<TypeInfo>();
            TreeSet<InterfaceEntry> interfaces = new TreeSet<InterfaceEntry>();
            this.flattenHierarchy(superclasses, interfaces, new HashSet<String>(), 0);
            ArrayList<TypeInfo> result = new ArrayList<TypeInfo>(superclasses.size() + interfaces.size() + 1);
            result.addAll(superclasses);
            result.addAll(ClassHierarchy.narrow(interfaces));
            result.add(ClassHierarchy.this.OBJECT);
            return result;
        }

        int flattenHierarchy(Queue<TypeInfo> superclasses, SortedSet<InterfaceEntry> interfaces, Set<String> ivisited, int depth) throws IOException {
            TypeInfo stype;
            int strength = this.initialStrength();
            if (!this.isInterface) {
                superclasses.add(this);
            }
            if (null != (stype = this.superClass())) {
                stype.flattenHierarchy(superclasses, interfaces, ivisited, depth + 1);
            }
            TypeInfo[] itypes = this.interfaces();
            int size = itypes.length;
            for (int i = size - 1; i >= 0; --i) {
                TypeInfo itype = itypes[i];
                strength += itype.flattenHierarchy(null, interfaces, ivisited, depth + 1);
            }
            if (this.isInterface) {
                if (!ivisited.contains(this.name)) {
                    interfaces.add(new InterfaceEntry(this, strength, depth));
                    ivisited.add(this.name);
                }
                return strength;
            }
            return 0;
        }

        int initialStrength() {
            return this.isInterface ? 1 : 0;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (null == other || !(other instanceof TypeInfo)) {
                return false;
            }
            return this == other || this.name.equals(((TypeInfo)other).name);
        }
    }
}

