/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.javaflow;

import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.tascalate.javaflow.function.SuspendableBiFunction;
import net.tascalate.javaflow.function.SuspendableConsumer;
import net.tascalate.javaflow.function.SuspendableFunction;
import net.tascalate.javaflow.function.SuspendablePredicate;
import net.tascalate.javaflow.function.SuspendableSupplier;
import org.apache.commons.javaflow.api.continuable;
import org.apache.commons.javaflow.core.Skip;
import org.apache.commons.javaflow.core.StackRecorder;

@Skip
public abstract class Option<T> {
    private static final Option<?> NULL = new Some<Object>(null);
    private static final Supplier<?> USE_NULL = () -> NULL;

    Option() {
    }

    public abstract boolean exists();

    public abstract T get();

    public final Option<T> orElseNull() {
        return this.orElse(Option.useNull());
    }

    public final Option<T> orElse(Option<T> alt) {
        return this.orElse(() -> alt);
    }

    public abstract Option<T> orElse(Supplier<? extends Option<T>> var1);

    @continuable
    public abstract Option<T> orElse$(SuspendableSupplier<? extends Option<? extends T>> var1);

    public abstract <R> Option<R> map(Function<? super T, ? extends R> var1);

    @continuable
    public abstract <R> Option<R> map$(SuspendableFunction<? super T, ? extends R> var1);

    public abstract <R> Option<R> flatMap(Function<? super T, ? extends Option<? extends R>> var1);

    @continuable
    public abstract <R> Option<R> flatMap$(SuspendableFunction<? super T, ? extends Option<? extends R>> var1);

    public abstract Option<T> filter(Predicate<? super T> var1);

    @continuable
    public abstract Option<T> filter$(SuspendablePredicate<? super T> var1);

    public abstract <U, R> Option<R> combine(Option<U> var1, BiFunction<? super T, ? super U, ? extends R> var2);

    @continuable
    public abstract <U, R> Option<R> combine$(Option<U> var1, SuspendableBiFunction<? super T, ? super U, ? extends R> var2);

    public abstract void accept(Consumer<? super T> var1);

    @continuable
    public abstract void accept$(SuspendableConsumer<? super T> var1);

    public static <T> Option<T> some(T value) {
        return new Some<T>(value);
    }

    public static <T> Option<T> none() {
        return None.INSTANCE;
    }

    private static <T> Supplier<Option<T>> useNull() {
        return USE_NULL;
    }

    static <T> Option<T> narrow(Option<? extends T> v) {
        return v;
    }

    @Skip
    public static class None<T>
    extends Option<T> {
        static final Option<?> INSTANCE = new None();

        private None() {
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public T get() {
            throw new NoSuchElementException();
        }

        @Override
        public Option<T> orElse(Supplier<? extends Option<T>> alt) {
            return alt.get();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Option<T> orElse$(SuspendableSupplier<? extends Option<? extends T>> var1_1) {
            __stackRecorder = StackRecorder.get();
            if (__stackRecorder == null || !__stackRecorder.isRestoring) ** GOTO lbl-1000
            switch (__stackRecorder.popInt()) {
                case 0: {
                    var1_1 = (SuspendableSupplier)__stackRecorder.popObject();
                    this = (None)__stackRecorder.popObject();
                    v0 = (SuspendableSupplier)__stackRecorder.popReference();
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 = alt;
                }
            }
            if (__stackRecorder != null && __stackRecorder.isCapturing) {
                __stackRecorder.pushReference((Object)this);
                __stackRecorder.pushObject((Object)this);
                __stackRecorder.pushObject((Object)alt);
                __stackRecorder.pushInt(0);
                return null;
            }
            return None.narrow((Option)v0.get());
        }

        @Override
        public <R> Option<R> map(Function<? super T, ? extends R> mapper) {
            return None.none();
        }

        @Override
        public <R> Option<R> map$(SuspendableFunction<? super T, ? extends R> mapper) {
            return None.none();
        }

        @Override
        public Option<T> filter(Predicate<? super T> predicate) {
            return this;
        }

        @Override
        public Option<T> filter$(SuspendablePredicate<? super T> predicate) {
            return this;
        }

        @Override
        public <R> Option<R> flatMap(Function<? super T, ? extends Option<? extends R>> mapper) {
            return None.none();
        }

        @Override
        public <R> Option<R> flatMap$(SuspendableFunction<? super T, ? extends Option<? extends R>> mapper) {
            return None.none();
        }

        @Override
        public <U, R> Option<R> combine(Option<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
            return None.none();
        }

        @Override
        public <U, R> Option<R> combine$(Option<U> other, SuspendableBiFunction<? super T, ? super U, ? extends R> zipper) {
            return None.none();
        }

        @Override
        public void accept(Consumer<? super T> action) {
        }

        @Override
        public void accept$(SuspendableConsumer<? super T> action) {
        }
    }

    @Skip
    public static class Some<T>
    extends Option<T> {
        private final T value;

        Some(T value) {
            this.value = value;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Option<T> orElse(Supplier<? extends Option<T>> alt) {
            return this;
        }

        @Override
        public Option<T> orElse$(SuspendableSupplier<? extends Option<? extends T>> alt) {
            return this;
        }

        @Override
        public <R> Option<R> map(Function<? super T, ? extends R> mapper) {
            return Some.some(mapper.apply(this.value));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public <R> Option<R> map$(SuspendableFunction<? super T, ? extends R> var1_1) {
            __stackRecorder = StackRecorder.get();
            if (__stackRecorder == null || !__stackRecorder.isRestoring) ** GOTO lbl-1000
            switch (__stackRecorder.popInt()) {
                case 0: {
                    var1_1 = (SuspendableFunction)__stackRecorder.popObject();
                    this = (Some)__stackRecorder.popObject();
                    v0 = (SuspendableFunction)__stackRecorder.popReference();
                    v1 = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 = mapper;
                    v1 = this.value;
                }
            }
            if (__stackRecorder != null && __stackRecorder.isCapturing) {
                __stackRecorder.pushReference((Object)this);
                __stackRecorder.pushObject((Object)this);
                __stackRecorder.pushObject((Object)mapper);
                __stackRecorder.pushInt(0);
                return null;
            }
            return Some.some(v0.apply(v1));
        }

        @Override
        public Option<T> filter(Predicate<? super T> predicate) {
            return predicate.test(this.value) ? this : Some.none();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Option<T> filter$(SuspendablePredicate<? super T> var1_1) {
            __stackRecorder = StackRecorder.get();
            if (__stackRecorder == null || !__stackRecorder.isRestoring) ** GOTO lbl-1000
            switch (__stackRecorder.popInt()) {
                case 0: {
                    var1_1 = (SuspendablePredicate)__stackRecorder.popObject();
                    this = (Some)__stackRecorder.popObject();
                    v0 = (SuspendablePredicate)__stackRecorder.popReference();
                    v1 = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 = predicate;
                    v1 = this.value;
                }
            }
            if (__stackRecorder != null && __stackRecorder.isCapturing) {
                __stackRecorder.pushReference((Object)this);
                __stackRecorder.pushObject((Object)this);
                __stackRecorder.pushObject((Object)predicate);
                __stackRecorder.pushInt(0);
                return null;
            }
            return v0.test(v1) != false ? this : Some.none();
        }

        @Override
        public <R> Option<R> flatMap(Function<? super T, ? extends Option<? extends R>> mapper) {
            return Some.narrow(mapper.apply(this.value));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public <R> Option<R> flatMap$(SuspendableFunction<? super T, ? extends Option<? extends R>> var1_1) {
            __stackRecorder = StackRecorder.get();
            if (__stackRecorder == null || !__stackRecorder.isRestoring) ** GOTO lbl-1000
            switch (__stackRecorder.popInt()) {
                case 0: {
                    var1_1 = (SuspendableFunction)__stackRecorder.popObject();
                    this = (Some)__stackRecorder.popObject();
                    v0 = (SuspendableFunction)__stackRecorder.popReference();
                    v1 = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 = mapper;
                    v1 = this.value;
                }
            }
            if (__stackRecorder != null && __stackRecorder.isCapturing) {
                __stackRecorder.pushReference((Object)this);
                __stackRecorder.pushObject((Object)this);
                __stackRecorder.pushObject((Object)mapper);
                __stackRecorder.pushInt(0);
                return null;
            }
            return Some.narrow((Option)v0.apply(v1));
        }

        @Override
        public <U, R> Option<R> combine(Option<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
            if (other.exists()) {
                Some someOther = (Some)other;
                return Some.some(zipper.apply(this.value, someOther.value));
            }
            return Some.none();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public <U, R> Option<R> combine$(Option<U> var1_1, SuspendableBiFunction<? super T, ? super U, ? extends R> var2_2) {
            block4: {
                __stackRecorder = StackRecorder.get();
                if (__stackRecorder == null || !__stackRecorder.isRestoring) ** GOTO lbl-1000
                switch (__stackRecorder.popInt()) {
                    case 0: {
                        var3_4 = (Some)__stackRecorder.popObject();
                        var2_2 = (SuspendableBiFunction)__stackRecorder.popObject();
                        var1_1 = (Option)__stackRecorder.popObject();
                        this = (Some)__stackRecorder.popObject();
                        v0 = (SuspendableBiFunction)__stackRecorder.popReference();
                        v1 = null;
                        v2 = null;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (!other.exists()) break block4;
                        someOther = (Some)other;
                        v0 = zipper;
                        v1 = this.value;
                        v2 = someOther.value;
                    }
                }
                if (__stackRecorder != null && __stackRecorder.isCapturing) {
                    __stackRecorder.pushReference((Object)this);
                    __stackRecorder.pushObject((Object)this);
                    __stackRecorder.pushObject((Object)other);
                    __stackRecorder.pushObject((Object)zipper);
                    __stackRecorder.pushObject((Object)someOther);
                    __stackRecorder.pushInt(0);
                    return null;
                }
                return Some.some(v0.apply(v1, v2));
            }
            return Some.none();
        }

        @Override
        public void accept(Consumer<? super T> action) {
            action.accept(this.value);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void accept$(SuspendableConsumer<? super T> var1_1) {
            __stackRecorder = StackRecorder.get();
            if (__stackRecorder == null || !__stackRecorder.isRestoring) ** GOTO lbl-1000
            switch (__stackRecorder.popInt()) {
                case 0: {
                    var1_1 = (SuspendableConsumer)__stackRecorder.popObject();
                    this = (Some)__stackRecorder.popObject();
                    v0 = (SuspendableConsumer)__stackRecorder.popReference();
                    v1 = null;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v0 = action;
                    v1 = this.value;
                }
            }
            v0.accept(v1);
            if (__stackRecorder != null && __stackRecorder.isCapturing) {
                __stackRecorder.pushReference((Object)this);
                __stackRecorder.pushObject((Object)this);
                __stackRecorder.pushObject((Object)action);
                __stackRecorder.pushInt(0);
                return;
            }
        }
    }
}

