/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.TouchOperation;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class TouchOperationImpl
extends OperationImpl
implements TouchOperation {
    private static final int OVERHEAD = 9;
    private static final OperationStatus OK = new OperationStatus(true, "TOUCHED");
    private final String key;
    private final long exp;

    public TouchOperationImpl(String k, long t, OperationCallback cb) {
        super(cb);
        this.key = k;
        this.exp = t;
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Touch completed successfully");
        this.getCallback().receivedStatus(this.matchStatus(line, OK));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = null;
        b = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + String.valueOf(this.exp).length() + 9);
        b.put(("touch " + this.key + " " + this.exp + "\r\n").getBytes());
        b.flip();
        this.setBuffer(b);
    }

    public String toString() {
        return "Cmd: touch key: " + this.key + " exp: " + this.exp;
    }
}

