/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.internal.GenericCompletionListener;
import net.spy.memcached.internal.ListenableFuture;

public abstract class AbstractListenableFuture<T, L extends GenericCompletionListener>
extends SpyObject
implements ListenableFuture<T, L> {
    private final ExecutorService service;
    private List<GenericCompletionListener<? extends Future<T>>> listeners;

    public AbstractListenableFuture(ExecutorService executor) {
        this.service = executor;
        this.listeners = new ArrayList<GenericCompletionListener<? extends Future<T>>>();
    }

    protected ExecutorService executor() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future<T> addToListeners(GenericCompletionListener<? extends Future<T>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener can't be null.");
        }
        if (this.isDone()) {
            this.notifyListener(this.executor(), this, listener);
            return this;
        }
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            if (!this.isDone()) {
                this.listeners.add(listener);
                return this;
            }
        }
        this.notifyListener(this.executor(), this, listener);
        return this;
    }

    protected void notifyListener(ExecutorService executor, final Future<?> future, final GenericCompletionListener listener) {
        executor.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("FutureNotifyListener");
                try {
                    listener.onComplete(future);
                }
                catch (Throwable t) {
                    AbstractListenableFuture.this.getLogger().warn((Object)("Exception thrown wile executing " + listener.getClass().getName() + ".operationComplete()"), t);
                }
            }
        });
    }

    protected void notifyListeners() {
        this.notifyListeners(this);
    }

    protected void notifyListeners(Future<?> future) {
        for (GenericCompletionListener<? extends Future<T>> genericCompletionListener : this.listeners) {
            this.notifyListener(this.executor(), future, genericCompletionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Future<T> removeFromListeners(GenericCompletionListener<? extends Future<T>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener can't be null.");
        }
        if (this.isDone()) {
            return this;
        }
        AbstractListenableFuture abstractListenableFuture = this;
        synchronized (abstractListenableFuture) {
            if (!this.isDone()) {
                this.listeners.remove(listener);
            }
        }
        return this;
    }
}

