/*
 * Decompiled with CFR 0.152.
 */
package java9.util.stream;

import java9.util.Objects;
import java9.util.Optional;
import java9.util.OptionalDouble;
import java9.util.OptionalInt;
import java9.util.OptionalLong;
import java9.util.Spliterator;
import java9.util.concurrent.CountedCompleter;
import java9.util.function.BiConsumer;
import java9.util.function.BiFunction;
import java9.util.function.BinaryOperator;
import java9.util.function.DoubleBinaryOperator;
import java9.util.function.IntBinaryOperator;
import java9.util.function.LongBinaryOperator;
import java9.util.function.ObjDoubleConsumer;
import java9.util.function.ObjIntConsumer;
import java9.util.function.ObjLongConsumer;
import java9.util.function.Supplier;
import java9.util.stream.AbstractTask;
import java9.util.stream.Collector;
import java9.util.stream.PipelineHelper;
import java9.util.stream.Sink;
import java9.util.stream.StreamOpFlag;
import java9.util.stream.StreamShape;
import java9.util.stream.TerminalOp;
import java9.util.stream.TerminalSink;

final class ReduceOps {
    private ReduceOps() {
    }

    public static <T, U> TerminalOp<T, U> makeRef(final U seed, final BiFunction<U, ? super T, U> reducer, final BinaryOperator<U> combiner) {
        Objects.requireNonNull(reducer);
        Objects.requireNonNull(combiner);
        return new ReduceOp<T, U, 1ReducingSink>(StreamShape.REFERENCE){

            @Override
            public 1ReducingSink makeSink() {
                class ReducingSink
                extends Box<U>
                implements AccumulatingSink<T, U, ReducingSink> {
                    final /* synthetic */ Object val$seed;
                    final /* synthetic */ BiFunction val$reducer;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$seed = object;
                        this.val$reducer = biFunction;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$seed;
                    }

                    @Override
                    public void accept(T t) {
                        this.state = this.val$reducer.apply(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.state = this.val$combiner.apply(this.state, other.state);
                    }
                }
                return new ReducingSink(seed, reducer, combiner);
            }
        };
    }

    public static <T> TerminalOp<T, Optional<T>> makeRef(final BinaryOperator<T> operator) {
        Objects.requireNonNull(operator);
        return new ReduceOp<T, Optional<T>, 2ReducingSink>(StreamShape.REFERENCE){

            @Override
            public 2ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<T, Optional<T>, ReducingSink> {
                    private boolean empty;
                    private T state;
                    final /* synthetic */ BinaryOperator val$operator;

                    ReducingSink(BinaryOperator binaryOperator) {
                        this.val$operator = binaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.empty = true;
                        this.state = null;
                    }

                    @Override
                    public void accept(T t) {
                        if (this.empty) {
                            this.empty = false;
                            this.state = t;
                        } else {
                            this.state = this.val$operator.apply(this.state, t);
                        }
                    }

                    @Override
                    public Optional<T> get() {
                        return this.empty ? Optional.empty() : Optional.of(this.state);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        if (!other.empty) {
                            this.accept(other.state);
                        }
                    }
                }
                return new ReducingSink(operator);
            }
        };
    }

    public static <T, I> TerminalOp<T, I> makeRef(final Collector<? super T, I, ?> collector) {
        final Supplier<I> supplier = Objects.requireNonNull(collector).supplier();
        final BiConsumer<I, ? super T> accumulator = collector.accumulator();
        final BinaryOperator<I> combiner = collector.combiner();
        return new ReduceOp<T, I, 3ReducingSink>(StreamShape.REFERENCE){

            @Override
            public 3ReducingSink makeSink() {
                class ReducingSink
                extends Box<I>
                implements AccumulatingSink<T, I, ReducingSink> {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ BiConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = biConsumer;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(T t) {
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.state = this.val$combiner.apply(this.state, other.state);
                    }
                }
                return new ReducingSink(supplier, accumulator, combiner);
            }

            @Override
            public int getOpFlags() {
                return collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED) ? StreamOpFlag.NOT_ORDERED : 0;
            }
        };
    }

    public static <T, R> TerminalOp<T, R> makeRef(final Supplier<R> seedFactory, final BiConsumer<R, ? super T> accumulator, final BiConsumer<R, R> reducer) {
        Objects.requireNonNull(seedFactory);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(reducer);
        return new ReduceOp<T, R, 4ReducingSink>(StreamShape.REFERENCE){

            @Override
            public 4ReducingSink makeSink() {
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<T, R, ReducingSink> {
                    final /* synthetic */ Supplier val$seedFactory;
                    final /* synthetic */ BiConsumer val$accumulator;
                    final /* synthetic */ BiConsumer val$reducer;

                    ReducingSink() {
                        this.val$seedFactory = supplier;
                        this.val$accumulator = biConsumer;
                        this.val$reducer = biConsumer2;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$seedFactory.get();
                    }

                    @Override
                    public void accept(T t) {
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.val$reducer.accept(this.state, other.state);
                    }
                }
                return new ReducingSink(seedFactory, accumulator, reducer);
            }
        };
    }

    public static <T> TerminalOp<T, Long> makeRefCounting() {
        return new ReduceOp<T, Long, CountingSink<T>>(StreamShape.REFERENCE){

            @Override
            public CountingSink<T> makeSink() {
                return new CountingSink.OfRef();
            }

            @Override
            public <P_IN> Long evaluateSequential(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.SIZED.isKnown(helper.getStreamAndOpFlags())) {
                    return spliterator.getExactSizeIfKnown();
                }
                return (Long)super.evaluateSequential(helper, spliterator);
            }

            @Override
            public <P_IN> Long evaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.SIZED.isKnown(helper.getStreamAndOpFlags())) {
                    return spliterator.getExactSizeIfKnown();
                }
                return (Long)super.evaluateParallel(helper, spliterator);
            }

            @Override
            public int getOpFlags() {
                return StreamOpFlag.NOT_ORDERED;
            }
        };
    }

    public static TerminalOp<Integer, Integer> makeInt(final int identity, final IntBinaryOperator operator) {
        Objects.requireNonNull(operator);
        return new ReduceOp<Integer, Integer, 5ReducingSink>(StreamShape.INT_VALUE){

            @Override
            public 5ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Integer, Integer, ReducingSink>,
                Sink.OfInt {
                    private int state;
                    final /* synthetic */ int val$identity;
                    final /* synthetic */ IntBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = n;
                        this.val$operator = intBinaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(int t) {
                        this.state = this.val$operator.applyAsInt(this.state, t);
                    }

                    @Override
                    public Integer get() {
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.accept(other.state);
                    }
                }
                return new ReducingSink(identity, operator);
            }
        };
    }

    public static TerminalOp<Integer, OptionalInt> makeInt(final IntBinaryOperator operator) {
        Objects.requireNonNull(operator);
        return new ReduceOp<Integer, OptionalInt, 6ReducingSink>(StreamShape.INT_VALUE){

            @Override
            public 6ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Integer, OptionalInt, ReducingSink>,
                Sink.OfInt {
                    private boolean empty;
                    private int state;
                    final /* synthetic */ IntBinaryOperator val$operator;

                    ReducingSink(IntBinaryOperator intBinaryOperator) {
                        this.val$operator = intBinaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.empty = true;
                        this.state = 0;
                    }

                    @Override
                    public void accept(int t) {
                        if (this.empty) {
                            this.empty = false;
                            this.state = t;
                        } else {
                            this.state = this.val$operator.applyAsInt(this.state, t);
                        }
                    }

                    @Override
                    public OptionalInt get() {
                        return this.empty ? OptionalInt.empty() : OptionalInt.of(this.state);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        if (!other.empty) {
                            this.accept(other.state);
                        }
                    }
                }
                return new ReducingSink(operator);
            }
        };
    }

    public static <R> TerminalOp<Integer, R> makeInt(final Supplier<R> supplier, final ObjIntConsumer<R> accumulator, final BinaryOperator<R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return new ReduceOp<Integer, R, 7ReducingSink>(StreamShape.INT_VALUE){

            @Override
            public 7ReducingSink makeSink() {
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Integer, R, ReducingSink>,
                Sink.OfInt {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjIntConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objIntConsumer;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(int t) {
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.state = this.val$combiner.apply(this.state, other.state);
                    }
                }
                return new ReducingSink(supplier, accumulator, combiner);
            }
        };
    }

    public static TerminalOp<Integer, Long> makeIntCounting() {
        return new ReduceOp<Integer, Long, CountingSink<Integer>>(StreamShape.INT_VALUE){

            @Override
            public CountingSink<Integer> makeSink() {
                return new CountingSink.OfInt();
            }

            @Override
            public <P_IN> Long evaluateSequential(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.SIZED.isKnown(helper.getStreamAndOpFlags())) {
                    return spliterator.getExactSizeIfKnown();
                }
                return (Long)super.evaluateSequential(helper, spliterator);
            }

            @Override
            public <P_IN> Long evaluateParallel(PipelineHelper<Integer> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.SIZED.isKnown(helper.getStreamAndOpFlags())) {
                    return spliterator.getExactSizeIfKnown();
                }
                return (Long)super.evaluateParallel(helper, spliterator);
            }

            @Override
            public int getOpFlags() {
                return StreamOpFlag.NOT_ORDERED;
            }
        };
    }

    public static TerminalOp<Long, Long> makeLong(final long identity, final LongBinaryOperator operator) {
        Objects.requireNonNull(operator);
        return new ReduceOp<Long, Long, 8ReducingSink>(StreamShape.LONG_VALUE){

            @Override
            public 8ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Long, Long, ReducingSink>,
                Sink.OfLong {
                    private long state;
                    final /* synthetic */ long val$identity;
                    final /* synthetic */ LongBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = l;
                        this.val$operator = longBinaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(long t) {
                        this.state = this.val$operator.applyAsLong(this.state, t);
                    }

                    @Override
                    public Long get() {
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.accept(other.state);
                    }
                }
                return new ReducingSink(identity, operator);
            }
        };
    }

    public static TerminalOp<Long, OptionalLong> makeLong(final LongBinaryOperator operator) {
        Objects.requireNonNull(operator);
        return new ReduceOp<Long, OptionalLong, 9ReducingSink>(StreamShape.LONG_VALUE){

            @Override
            public 9ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Long, OptionalLong, ReducingSink>,
                Sink.OfLong {
                    private boolean empty;
                    private long state;
                    final /* synthetic */ LongBinaryOperator val$operator;

                    ReducingSink(LongBinaryOperator longBinaryOperator) {
                        this.val$operator = longBinaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.empty = true;
                        this.state = 0L;
                    }

                    @Override
                    public void accept(long t) {
                        if (this.empty) {
                            this.empty = false;
                            this.state = t;
                        } else {
                            this.state = this.val$operator.applyAsLong(this.state, t);
                        }
                    }

                    @Override
                    public OptionalLong get() {
                        return this.empty ? OptionalLong.empty() : OptionalLong.of(this.state);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        if (!other.empty) {
                            this.accept(other.state);
                        }
                    }
                }
                return new ReducingSink(operator);
            }
        };
    }

    public static <R> TerminalOp<Long, R> makeLong(final Supplier<R> supplier, final ObjLongConsumer<R> accumulator, final BinaryOperator<R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return new ReduceOp<Long, R, 10ReducingSink>(StreamShape.LONG_VALUE){

            @Override
            public 10ReducingSink makeSink() {
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Long, R, ReducingSink>,
                Sink.OfLong {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjLongConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objLongConsumer;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(long t) {
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.state = this.val$combiner.apply(this.state, other.state);
                    }
                }
                return new ReducingSink(supplier, accumulator, combiner);
            }
        };
    }

    public static TerminalOp<Long, Long> makeLongCounting() {
        return new ReduceOp<Long, Long, CountingSink<Long>>(StreamShape.LONG_VALUE){

            @Override
            public CountingSink<Long> makeSink() {
                return new CountingSink.OfLong();
            }

            @Override
            public <P_IN> Long evaluateSequential(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.SIZED.isKnown(helper.getStreamAndOpFlags())) {
                    return spliterator.getExactSizeIfKnown();
                }
                return (Long)super.evaluateSequential(helper, spliterator);
            }

            @Override
            public <P_IN> Long evaluateParallel(PipelineHelper<Long> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.SIZED.isKnown(helper.getStreamAndOpFlags())) {
                    return spliterator.getExactSizeIfKnown();
                }
                return (Long)super.evaluateParallel(helper, spliterator);
            }

            @Override
            public int getOpFlags() {
                return StreamOpFlag.NOT_ORDERED;
            }
        };
    }

    public static TerminalOp<Double, Double> makeDouble(final double identity, final DoubleBinaryOperator operator) {
        Objects.requireNonNull(operator);
        return new ReduceOp<Double, Double, 11ReducingSink>(StreamShape.DOUBLE_VALUE){

            @Override
            public 11ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Double, Double, ReducingSink>,
                Sink.OfDouble {
                    private double state;
                    final /* synthetic */ double val$identity;
                    final /* synthetic */ DoubleBinaryOperator val$operator;

                    ReducingSink() {
                        this.val$identity = d;
                        this.val$operator = doubleBinaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$identity;
                    }

                    @Override
                    public void accept(double t) {
                        this.state = this.val$operator.applyAsDouble(this.state, t);
                    }

                    @Override
                    public Double get() {
                        return this.state;
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.accept(other.state);
                    }
                }
                return new ReducingSink(identity, operator);
            }
        };
    }

    public static TerminalOp<Double, OptionalDouble> makeDouble(final DoubleBinaryOperator operator) {
        Objects.requireNonNull(operator);
        return new ReduceOp<Double, OptionalDouble, 12ReducingSink>(StreamShape.DOUBLE_VALUE){

            @Override
            public 12ReducingSink makeSink() {
                class ReducingSink
                implements AccumulatingSink<Double, OptionalDouble, ReducingSink>,
                Sink.OfDouble {
                    private boolean empty;
                    private double state;
                    final /* synthetic */ DoubleBinaryOperator val$operator;

                    ReducingSink(DoubleBinaryOperator doubleBinaryOperator) {
                        this.val$operator = doubleBinaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.empty = true;
                        this.state = 0.0;
                    }

                    @Override
                    public void accept(double t) {
                        if (this.empty) {
                            this.empty = false;
                            this.state = t;
                        } else {
                            this.state = this.val$operator.applyAsDouble(this.state, t);
                        }
                    }

                    @Override
                    public OptionalDouble get() {
                        return this.empty ? OptionalDouble.empty() : OptionalDouble.of(this.state);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        if (!other.empty) {
                            this.accept(other.state);
                        }
                    }
                }
                return new ReducingSink(operator);
            }
        };
    }

    public static <R> TerminalOp<Double, R> makeDouble(final Supplier<R> supplier, final ObjDoubleConsumer<R> accumulator, final BinaryOperator<R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return new ReduceOp<Double, R, 13ReducingSink>(StreamShape.DOUBLE_VALUE){

            @Override
            public 13ReducingSink makeSink() {
                class ReducingSink
                extends Box<R>
                implements AccumulatingSink<Double, R, ReducingSink>,
                Sink.OfDouble {
                    final /* synthetic */ Supplier val$supplier;
                    final /* synthetic */ ObjDoubleConsumer val$accumulator;
                    final /* synthetic */ BinaryOperator val$combiner;

                    ReducingSink() {
                        this.val$supplier = supplier;
                        this.val$accumulator = objDoubleConsumer;
                        this.val$combiner = binaryOperator;
                    }

                    @Override
                    public void begin(long size) {
                        this.state = this.val$supplier.get();
                    }

                    @Override
                    public void accept(double t) {
                        this.val$accumulator.accept(this.state, t);
                    }

                    @Override
                    public void combine(ReducingSink other) {
                        this.state = this.val$combiner.apply(this.state, other.state);
                    }
                }
                return new ReducingSink(supplier, accumulator, combiner);
            }
        };
    }

    public static TerminalOp<Double, Long> makeDoubleCounting() {
        return new ReduceOp<Double, Long, CountingSink<Double>>(StreamShape.DOUBLE_VALUE){

            @Override
            public CountingSink<Double> makeSink() {
                return new CountingSink.OfDouble();
            }

            @Override
            public <P_IN> Long evaluateSequential(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.SIZED.isKnown(helper.getStreamAndOpFlags())) {
                    return spliterator.getExactSizeIfKnown();
                }
                return (Long)super.evaluateSequential(helper, spliterator);
            }

            @Override
            public <P_IN> Long evaluateParallel(PipelineHelper<Double> helper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.SIZED.isKnown(helper.getStreamAndOpFlags())) {
                    return spliterator.getExactSizeIfKnown();
                }
                return (Long)super.evaluateParallel(helper, spliterator);
            }

            @Override
            public int getOpFlags() {
                return StreamOpFlag.NOT_ORDERED;
            }
        };
    }

    private static final class ReduceTask<P_IN, P_OUT, R, S extends AccumulatingSink<P_OUT, R, S>>
    extends AbstractTask<P_IN, P_OUT, S, ReduceTask<P_IN, P_OUT, R, S>> {
        private final ReduceOp<P_OUT, R, S> op;

        ReduceTask(ReduceOp<P_OUT, R, S> op, PipelineHelper<P_OUT> helper, Spliterator<P_IN> spliterator) {
            super(helper, spliterator);
            this.op = op;
        }

        ReduceTask(ReduceTask<P_IN, P_OUT, R, S> parent, Spliterator<P_IN> spliterator) {
            super(parent, spliterator);
            this.op = parent.op;
        }

        @Override
        protected ReduceTask<P_IN, P_OUT, R, S> makeChild(Spliterator<P_IN> spliterator) {
            return new ReduceTask<P_IN, P_OUT, R, S>(this, spliterator);
        }

        @Override
        protected S doLeaf() {
            return (S)((AccumulatingSink)this.helper.wrapAndCopyInto(this.op.makeSink(), this.spliterator));
        }

        @Override
        public void onCompletion(CountedCompleter<?> caller) {
            if (!this.isLeaf()) {
                AccumulatingSink leftResult = (AccumulatingSink)((ReduceTask)this.leftChild).getLocalResult();
                leftResult.combine((AccumulatingSink)((ReduceTask)this.rightChild).getLocalResult());
                this.setLocalResult(leftResult);
            }
            super.onCompletion(caller);
        }
    }

    private static abstract class ReduceOp<T, R, S extends AccumulatingSink<T, R, S>>
    implements TerminalOp<T, R> {
        private final StreamShape inputShape;

        ReduceOp(StreamShape shape) {
            this.inputShape = shape;
        }

        public abstract S makeSink();

        @Override
        public StreamShape inputShape() {
            return this.inputShape;
        }

        @Override
        public <P_IN> R evaluateSequential(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
            return (R)((AccumulatingSink)helper.wrapAndCopyInto(this.makeSink(), spliterator)).get();
        }

        @Override
        public <P_IN> R evaluateParallel(PipelineHelper<T> helper, Spliterator<P_IN> spliterator) {
            return (R)((AccumulatingSink)new ReduceTask(this, helper, spliterator).invoke()).get();
        }
    }

    private static abstract class Box<U> {
        U state;

        Box() {
        }

        public U get() {
            return this.state;
        }
    }

    private static interface AccumulatingSink<T, R, K extends AccumulatingSink<T, R, K>>
    extends TerminalSink<T, R> {
        public void combine(K var1);
    }

    static abstract class CountingSink<T>
    extends Box<Long>
    implements AccumulatingSink<T, Long, CountingSink<T>> {
        long count;

        CountingSink() {
        }

        @Override
        public void begin(long size) {
            this.count = 0L;
        }

        @Override
        public Long get() {
            return this.count;
        }

        @Override
        public void combine(CountingSink<T> other) {
            this.count += other.count;
        }

        static final class OfDouble
        extends CountingSink<Double>
        implements Sink.OfDouble {
            OfDouble() {
            }

            @Override
            public void accept(double t) {
                ++this.count;
            }
        }

        static final class OfLong
        extends CountingSink<Long>
        implements Sink.OfLong {
            OfLong() {
            }

            @Override
            public void accept(long t) {
                ++this.count;
            }
        }

        static final class OfInt
        extends CountingSink<Integer>
        implements Sink.OfInt {
            OfInt() {
            }

            @Override
            public void accept(int t) {
                ++this.count;
            }
        }

        static final class OfRef<T>
        extends CountingSink<T> {
            OfRef() {
            }

            @Override
            public void accept(T t) {
                ++this.count;
            }
        }
    }
}

