/*
 * Decompiled with CFR 0.152.
 */
package java9.util.function;

import java.util.Comparator;
import java9.util.Objects;
import java9.util.function.BiFunction;

public interface BinaryOperator<T>
extends BiFunction<T, T, T> {
    public static <T> BinaryOperator<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> BinaryOperator<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }
}

