/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.ConcurrentModificationException;
import java.util.PriorityQueue;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.Spliterators;
import java9.util.UnsafeAccess;
import java9.util.function.Consumer;
import sun.misc.Unsafe;

final class PQueueSpliterator<E>
implements Spliterator<E> {
    private final PriorityQueue<E> pq;
    private int index;
    private int fence;
    private int expectedModCount;
    private static final boolean IS_HARMONY = Spliterators.IS_HARMONY_ANDROID;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long SIZE_OFF;
    private static final long MODCOUNT_OFF;
    private static final long QUEUE_OFF;

    private PQueueSpliterator(PriorityQueue<E> pq, int origin, int fence, int expectedModCount) {
        this.pq = pq;
        this.index = origin;
        this.fence = fence;
        this.expectedModCount = expectedModCount;
    }

    static <T> Spliterator<T> spliterator(PriorityQueue<T> pq) {
        return new PQueueSpliterator<T>(pq, 0, -1, 0);
    }

    private int getFence() {
        int hi = this.fence;
        if (hi < 0) {
            this.expectedModCount = PQueueSpliterator.getModCount(this.pq);
            hi = this.fence = PQueueSpliterator.getSize(this.pq);
        }
        return hi;
    }

    @Override
    public PQueueSpliterator<E> trySplit() {
        PQueueSpliterator<E> pQueueSpliterator;
        int lo = this.index;
        int hi = this.getFence();
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            pQueueSpliterator = null;
        } else {
            this.index = mid;
            PQueueSpliterator<E> pQueueSpliterator2 = new PQueueSpliterator<E>(this.pq, lo, this.index, this.expectedModCount);
            pQueueSpliterator = pQueueSpliterator2;
        }
        return pQueueSpliterator;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Object e;
        int hi;
        Objects.requireNonNull(action);
        PriorityQueue<E> q = this.pq;
        if (this.fence < 0) {
            this.fence = PQueueSpliterator.getSize(q);
            this.expectedModCount = PQueueSpliterator.getModCount(q);
        }
        Object[] a = PQueueSpliterator.getQueue(q);
        this.index = hi = this.fence;
        for (int i = this.index; i < hi && (e = a[i]) != null; ++i) {
            action.accept(e);
        }
        if (PQueueSpliterator.getModCount(q) != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        int i;
        Objects.requireNonNull(action);
        PriorityQueue<E> q = this.pq;
        if (this.fence < 0) {
            this.fence = PQueueSpliterator.getSize(q);
            this.expectedModCount = PQueueSpliterator.getModCount(q);
        }
        if ((i = this.index) < this.fence) {
            this.index = i + 1;
            Object e = PQueueSpliterator.getQueue(q)[i];
            if (e == null || PQueueSpliterator.getModCount(q) != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            action.accept(e);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.getFence() - this.index;
    }

    @Override
    public int characteristics() {
        return 16704;
    }

    private static <T> int getSize(PriorityQueue<T> pq) {
        return U.getInt(pq, SIZE_OFF);
    }

    private static <T> int getModCount(PriorityQueue<T> pq) {
        if (IS_HARMONY) {
            return 0;
        }
        return U.getInt(pq, MODCOUNT_OFF);
    }

    private static <T> Object[] getQueue(PriorityQueue<T> pq) {
        return (Object[])U.getObject(pq, QUEUE_OFF);
    }

    static {
        try {
            SIZE_OFF = U.objectFieldOffset(PriorityQueue.class.getDeclaredField("size"));
            MODCOUNT_OFF = !IS_HARMONY ? U.objectFieldOffset(PriorityQueue.class.getDeclaredField("modCount")) : 0L;
            String queueFieldName = IS_HARMONY ? "elements" : "queue";
            QUEUE_OFF = U.objectFieldOffset(PriorityQueue.class.getDeclaredField(queueFieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

