/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.Spliterators;
import java9.util.UnsafeAccess;
import java9.util.function.Consumer;
import sun.misc.Unsafe;

final class LinkedListSpliterator<T>
implements Spliterator<T> {
    private static final int BATCH_UNIT = 1024;
    private static final int MAX_BATCH = 0x2000000;
    private final LinkedList<T> list;
    private final Object endOfList;
    private Object current;
    private int est;
    private int expectedModCount;
    private int batch;
    private static final boolean IS_HARMONY = Spliterators.IS_HARMONY_ANDROID;
    private static final boolean IS_JAVA6 = Spliterators.IS_JAVA6;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long SIZE_OFF;
    private static final long MODCOUNT_OFF;
    private static final long FIRST_OFF;
    private static final long NODE_ITEM_OFF;
    private static final long NODE_NEXT_OFF;

    private LinkedListSpliterator(LinkedList<T> list, int est, int expectedModCount) {
        this.list = list;
        this.est = est;
        this.expectedModCount = expectedModCount;
        this.endOfList = IS_JAVA6 || IS_HARMONY ? LinkedListSpliterator.getHeader(list) : null;
    }

    static <E> Spliterator<E> spliterator(LinkedList<E> list) {
        return new LinkedListSpliterator<E>(list, -1, 0);
    }

    private int getEst() {
        int s = this.est;
        if (s < 0) {
            LinkedList<T> lst = this.list;
            if (lst == null) {
                this.est = 0;
                s = 0;
            } else {
                this.expectedModCount = LinkedListSpliterator.getModCount(lst);
                this.current = this.getFirst(lst);
                s = this.est = LinkedListSpliterator.getSize(lst);
            }
        }
        return s;
    }

    @Override
    public int characteristics() {
        return 16464;
    }

    @Override
    public long estimateSize() {
        return this.getEst();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        Object p;
        Objects.requireNonNull(action);
        Object eol = this.endOfList;
        int n = this.getEst();
        if (n > 0 && (p = this.current) != eol) {
            this.current = eol;
            this.est = 0;
            do {
                Object item = LinkedListSpliterator.getNodeItem(p);
                p = LinkedListSpliterator.getNextNode(p);
                action.accept(item);
            } while (p != eol && --n > 0);
        }
        if (this.expectedModCount != LinkedListSpliterator.getModCount(this.list)) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Object p;
        Objects.requireNonNull(action);
        Object eol = this.endOfList;
        if (this.getEst() > 0 && (p = this.current) != eol) {
            --this.est;
            Object item = LinkedListSpliterator.getNodeItem(p);
            this.current = LinkedListSpliterator.getNextNode(p);
            action.accept(item);
            if (this.expectedModCount != LinkedListSpliterator.getModCount(this.list)) {
                throw new ConcurrentModificationException();
            }
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        Object p;
        Object eol = this.endOfList;
        int s = this.getEst();
        if (s > 1 && (p = this.current) != eol) {
            int n = this.batch + 1024;
            if (n > s) {
                n = s;
            }
            if (n > 0x2000000) {
                n = 0x2000000;
            }
            Object[] a = new Object[n];
            int j = 0;
            do {
                a[j++] = LinkedListSpliterator.getNodeItem(p);
            } while ((p = LinkedListSpliterator.getNextNode(p)) != eol && j < n);
            this.current = p;
            this.batch = j;
            this.est = s - j;
            return Spliterators.spliterator(a, 0, j, 16);
        }
        return null;
    }

    private static Object getHeader(LinkedList<?> list) {
        if (list == null) {
            return null;
        }
        return U.getObject(list, FIRST_OFF);
    }

    private Object getFirst(LinkedList<?> list) {
        if (IS_JAVA6 || IS_HARMONY) {
            return LinkedListSpliterator.getNextNode(this.endOfList);
        }
        return U.getObject(list, FIRST_OFF);
    }

    private static Object getNextNode(Object node) {
        if (node == null) {
            throw new ConcurrentModificationException();
        }
        return U.getObject(node, NODE_NEXT_OFF);
    }

    private static <E> E getNodeItem(Object node) {
        if (node == null) {
            throw new ConcurrentModificationException();
        }
        return (E)U.getObject(node, NODE_ITEM_OFF);
    }

    private static int getSize(LinkedList<?> list) {
        return U.getInt(list, SIZE_OFF);
    }

    private static int getModCount(LinkedList<?> list) {
        return U.getInt(list, MODCOUNT_OFF);
    }

    static {
        try {
            String nodeClassName;
            String firstFieldName;
            MODCOUNT_OFF = U.objectFieldOffset(AbstractList.class.getDeclaredField("modCount"));
            String string = IS_HARMONY ? "voidLink" : (firstFieldName = IS_JAVA6 ? "header" : "first");
            String string2 = IS_HARMONY ? "java.util.LinkedList$Link" : (nodeClassName = IS_JAVA6 ? "java.util.LinkedList$Entry" : "java.util.LinkedList$Node");
            String nodeItemName = IS_HARMONY ? "data" : (IS_JAVA6 ? "element" : "item");
            Class<?> nc = Class.forName(nodeClassName);
            SIZE_OFF = U.objectFieldOffset(LinkedList.class.getDeclaredField("size"));
            FIRST_OFF = U.objectFieldOffset(LinkedList.class.getDeclaredField(firstFieldName));
            NODE_ITEM_OFF = U.objectFieldOffset(nc.getDeclaredField(nodeItemName));
            NODE_NEXT_OFF = U.objectFieldOffset(nc.getDeclaredField("next"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

