/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.Enumeration;
import java.util.Iterator;
import java9.util.Objects;
import java9.util.function.Consumer;

public final class Iterators {
    public static <E> void forEachRemaining(Iterator<E> it, Consumer<? super E> action) {
        Objects.requireNonNull(it);
        Objects.requireNonNull(action);
        while (it.hasNext()) {
            action.accept(it.next());
        }
    }

    public static <E> Iterator<E> asIterator(final Enumeration<E> en) {
        Objects.requireNonNull(en);
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public E next() {
                return en.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    private Iterators() {
    }
}

