/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.Comparator;
import java9.util.DualPivotQuicksort;
import java9.util.TimSort;
import java9.util.concurrent.CountedCompleter;

class ArraysParallelSortHelpers {
    ArraysParallelSortHelpers() {
    }

    static final class FJDouble {
        FJDouble() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final double[] a;
            final double[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> par, double[] a, double[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                double[] a = this.a;
                double[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    double split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (split <= a[rm + rb]) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (split <= a[lm + lb]) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger m = new Merger(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    double t;
                    double d;
                    double d2;
                    double al = a[lb];
                    double ar = a[rb];
                    if (d2 <= d) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final double[] a;
            final double[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> par, double[] a, double[] w, int base, int size, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                double[] a = this.a;
                double[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger(s, w, a, wb, h, wb + h, n - h, b, g));
                    Relay rc = new Relay(new Merger(fc, a, w, b + h, q, b + u, n - u, wb + h, g));
                    new Sorter(rc, a, w, b + u, n - u, wb + u, g).fork();
                    new Sorter(rc, a, w, b + h, q, wb + h, g).fork();
                    Relay bc = new Relay(new Merger(fc, a, w, b, q, b + q, h - q, wb, g));
                    new Sorter(bc, a, w, b + q, h - q, wb + q, g).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                DualPivotQuicksort.sort(a, b, b + n - 1, w, wb, n);
                s.tryComplete();
            }
        }
    }

    static final class FJFloat {
        FJFloat() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final float[] a;
            final float[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> par, float[] a, float[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                float[] a = this.a;
                float[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    float split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (split <= a[rm + rb]) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (split <= a[lm + lb]) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger m = new Merger(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    float t;
                    float f;
                    float f2;
                    float al = a[lb];
                    float ar = a[rb];
                    if (f2 <= f) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final float[] a;
            final float[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> par, float[] a, float[] w, int base, int size, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                float[] a = this.a;
                float[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger(s, w, a, wb, h, wb + h, n - h, b, g));
                    Relay rc = new Relay(new Merger(fc, a, w, b + h, q, b + u, n - u, wb + h, g));
                    new Sorter(rc, a, w, b + u, n - u, wb + u, g).fork();
                    new Sorter(rc, a, w, b + h, q, wb + h, g).fork();
                    Relay bc = new Relay(new Merger(fc, a, w, b, q, b + q, h - q, wb, g));
                    new Sorter(bc, a, w, b + q, h - q, wb + q, g).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                DualPivotQuicksort.sort(a, b, b + n - 1, w, wb, n);
                s.tryComplete();
            }
        }
    }

    static final class FJLong {
        FJLong() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final long[] a;
            final long[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> par, long[] a, long[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                long[] a = this.a;
                long[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    long split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (split <= a[rm + rb]) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (split <= a[lm + lb]) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger m = new Merger(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    long t;
                    long al = a[lb];
                    long ar = a[rb];
                    if (al <= ar) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final long[] a;
            final long[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> par, long[] a, long[] w, int base, int size, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                long[] a = this.a;
                long[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger(s, w, a, wb, h, wb + h, n - h, b, g));
                    Relay rc = new Relay(new Merger(fc, a, w, b + h, q, b + u, n - u, wb + h, g));
                    new Sorter(rc, a, w, b + u, n - u, wb + u, g).fork();
                    new Sorter(rc, a, w, b + h, q, wb + h, g).fork();
                    Relay bc = new Relay(new Merger(fc, a, w, b, q, b + q, h - q, wb, g));
                    new Sorter(bc, a, w, b + q, h - q, wb + q, g).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                DualPivotQuicksort.sort(a, b, b + n - 1, w, wb, n);
                s.tryComplete();
            }
        }
    }

    static final class FJInt {
        FJInt() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final int[] a;
            final int[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> par, int[] a, int[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                int[] a = this.a;
                int[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    int split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (split <= a[rm + rb]) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (split <= a[lm + lb]) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger m = new Merger(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    int t;
                    int al = a[lb];
                    int ar = a[rb];
                    if (al <= ar) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final int[] a;
            final int[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> par, int[] a, int[] w, int base, int size, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                int[] a = this.a;
                int[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger(s, w, a, wb, h, wb + h, n - h, b, g));
                    Relay rc = new Relay(new Merger(fc, a, w, b + h, q, b + u, n - u, wb + h, g));
                    new Sorter(rc, a, w, b + u, n - u, wb + u, g).fork();
                    new Sorter(rc, a, w, b + h, q, wb + h, g).fork();
                    Relay bc = new Relay(new Merger(fc, a, w, b, q, b + q, h - q, wb, g));
                    new Sorter(bc, a, w, b + q, h - q, wb + q, g).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                DualPivotQuicksort.sort(a, b, b + n - 1, w, wb, n);
                s.tryComplete();
            }
        }
    }

    static final class FJShort {
        FJShort() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final short[] a;
            final short[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> par, short[] a, short[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                short[] a = this.a;
                short[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    short split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (split <= a[rm + rb]) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (split <= a[lm + lb]) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger m = new Merger(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    short t;
                    short al = a[lb];
                    short ar = a[rb];
                    if (al <= ar) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final short[] a;
            final short[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> par, short[] a, short[] w, int base, int size, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                short[] a = this.a;
                short[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger(s, w, a, wb, h, wb + h, n - h, b, g));
                    Relay rc = new Relay(new Merger(fc, a, w, b + h, q, b + u, n - u, wb + h, g));
                    new Sorter(rc, a, w, b + u, n - u, wb + u, g).fork();
                    new Sorter(rc, a, w, b + h, q, wb + h, g).fork();
                    Relay bc = new Relay(new Merger(fc, a, w, b, q, b + q, h - q, wb, g));
                    new Sorter(bc, a, w, b + q, h - q, wb + q, g).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                DualPivotQuicksort.sort(a, b, b + n - 1, w, wb, n);
                s.tryComplete();
            }
        }
    }

    static final class FJChar {
        FJChar() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final char[] a;
            final char[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> par, char[] a, char[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                char[] a = this.a;
                char[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    char split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (split <= a[rm + rb]) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (split <= a[lm + lb]) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger m = new Merger(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    char t;
                    char al = a[lb];
                    char ar = a[rb];
                    if (al <= ar) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final char[] a;
            final char[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> par, char[] a, char[] w, int base, int size, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                char[] a = this.a;
                char[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger(s, w, a, wb, h, wb + h, n - h, b, g));
                    Relay rc = new Relay(new Merger(fc, a, w, b + h, q, b + u, n - u, wb + h, g));
                    new Sorter(rc, a, w, b + u, n - u, wb + u, g).fork();
                    new Sorter(rc, a, w, b + h, q, wb + h, g).fork();
                    Relay bc = new Relay(new Merger(fc, a, w, b, q, b + q, h - q, wb, g));
                    new Sorter(bc, a, w, b + q, h - q, wb + q, g).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                DualPivotQuicksort.sort(a, b, b + n - 1, w, wb, n);
                s.tryComplete();
            }
        }
    }

    static final class FJByte {
        FJByte() {
        }

        static final class Merger
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final byte[] a;
            final byte[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;

            Merger(CountedCompleter<?> par, byte[] a, byte[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                byte[] a = this.a;
                byte[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    byte split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (split <= a[rm + rb]) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (split <= a[lm + lb]) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger m = new Merger(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    byte t;
                    byte al = a[lb];
                    byte ar = a[rb];
                    if (al <= ar) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final byte[] a;
            final byte[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;

            Sorter(CountedCompleter<?> par, byte[] a, byte[] w, int base, int size, int wbase, int gran) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                byte[] a = this.a;
                byte[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger(s, w, a, wb, h, wb + h, n - h, b, g));
                    Relay rc = new Relay(new Merger(fc, a, w, b + h, q, b + u, n - u, wb + h, g));
                    new Sorter(rc, a, w, b + u, n - u, wb + u, g).fork();
                    new Sorter(rc, a, w, b + h, q, wb + h, g).fork();
                    Relay bc = new Relay(new Merger(fc, a, w, b, q, b + q, h - q, wb, g));
                    new Sorter(bc, a, w, b + q, h - q, wb + q, g).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                DualPivotQuicksort.sort(a, b, b + n - 1);
                s.tryComplete();
            }
        }
    }

    static final class FJObject {
        FJObject() {
        }

        static final class Merger<T>
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final T[] a;
            final T[] w;
            final int lbase;
            final int lsize;
            final int rbase;
            final int rsize;
            final int wbase;
            final int gran;
            Comparator<? super T> comparator;

            Merger(CountedCompleter<?> par, T[] a, T[] w, int lbase, int lsize, int rbase, int rsize, int wbase, int gran, Comparator<? super T> comparator) {
                super(par);
                this.a = a;
                this.w = w;
                this.lbase = lbase;
                this.lsize = lsize;
                this.rbase = rbase;
                this.rsize = rsize;
                this.wbase = wbase;
                this.gran = gran;
                this.comparator = comparator;
            }

            @Override
            public final void compute() {
                Comparator<T> c = this.comparator;
                T[] a = this.a;
                T[] w = this.w;
                int lb = this.lbase;
                int ln = this.lsize;
                int rb = this.rbase;
                int rn = this.rsize;
                int k = this.wbase;
                int g = this.gran;
                if (a == null || w == null || lb < 0 || rb < 0 || k < 0 || c == null) {
                    throw new IllegalStateException();
                }
                while (true) {
                    int lo;
                    T split;
                    int lh;
                    int rh;
                    if (ln >= rn) {
                        if (ln <= g) break;
                        rh = rn;
                        lh = ln >>> 1;
                        split = a[lh + lb];
                        lo = 0;
                        while (lo < rh) {
                            int rm = lo + rh >>> 1;
                            if (c.compare(split, a[rm + rb]) <= 0) {
                                rh = rm;
                                continue;
                            }
                            lo = rm + 1;
                        }
                    } else {
                        if (rn <= g) break;
                        lh = ln;
                        rh = rn >>> 1;
                        split = a[rh + rb];
                        lo = 0;
                        while (lo < lh) {
                            int lm = lo + lh >>> 1;
                            if (c.compare(split, a[lm + lb]) <= 0) {
                                lh = lm;
                                continue;
                            }
                            lo = lm + 1;
                        }
                    }
                    Merger<T> m = new Merger<T>(this, a, w, lb + lh, ln - lh, rb + rh, rn - rh, k + lh + rh, g, c);
                    rn = rh;
                    ln = lh;
                    this.addToPendingCount(1);
                    m.fork();
                }
                int lf = lb + ln;
                int rf = rb + rn;
                while (lb < lf && rb < rf) {
                    T t;
                    T al = a[lb];
                    T ar = a[rb];
                    if (c.compare(al, ar) <= 0) {
                        ++lb;
                        t = al;
                    } else {
                        ++rb;
                        t = ar;
                    }
                    w[k++] = t;
                }
                if (rb < rf) {
                    System.arraycopy(a, rb, w, k, rf - rb);
                } else if (lb < lf) {
                    System.arraycopy(a, lb, w, k, lf - lb);
                }
                this.tryComplete();
            }
        }

        static final class Sorter<T>
        extends CountedCompleter<Void> {
            static final long serialVersionUID = 2446542900576103244L;
            final T[] a;
            final T[] w;
            final int base;
            final int size;
            final int wbase;
            final int gran;
            Comparator<? super T> comparator;

            Sorter(CountedCompleter<?> par, T[] a, T[] w, int base, int size, int wbase, int gran, Comparator<? super T> comparator) {
                super(par);
                this.a = a;
                this.w = w;
                this.base = base;
                this.size = size;
                this.wbase = wbase;
                this.gran = gran;
                this.comparator = comparator;
            }

            @Override
            public final void compute() {
                CountedCompleter s = this;
                Comparator<? super T> c = this.comparator;
                T[] a = this.a;
                T[] w = this.w;
                int b = this.base;
                int n = this.size;
                int wb = this.wbase;
                int g = this.gran;
                while (n > g) {
                    int h = n >>> 1;
                    int q = h >>> 1;
                    int u = h + q;
                    Relay fc = new Relay(new Merger<T>(s, w, a, wb, h, wb + h, n - h, b, g, c));
                    Relay rc = new Relay(new Merger<T>(fc, a, w, b + h, q, b + u, n - u, wb + h, g, c));
                    new Sorter<T>(rc, a, w, b + u, n - u, wb + u, g, c).fork();
                    new Sorter<T>(rc, a, w, b + h, q, wb + h, g, c).fork();
                    Relay bc = new Relay(new Merger<T>(fc, a, w, b, q, b + q, h - q, wb, g, c));
                    new Sorter<T>(bc, a, w, b + q, h - q, wb + q, g, c).fork();
                    s = new EmptyCompleter(bc);
                    n = q;
                }
                TimSort.sort(a, b, b + n, c, w, wb, n);
                s.tryComplete();
            }
        }
    }

    static final class Relay
    extends CountedCompleter<Void> {
        static final long serialVersionUID = 2446542900576103244L;
        final CountedCompleter<?> task;

        Relay(CountedCompleter<?> task) {
            super(null, 1);
            this.task = task;
        }

        @Override
        public final void compute() {
        }

        @Override
        public final void onCompletion(CountedCompleter<?> t) {
            this.task.compute();
        }
    }

    static final class EmptyCompleter
    extends CountedCompleter<Void> {
        static final long serialVersionUID = 2446542900576103244L;

        EmptyCompleter(CountedCompleter<?> p) {
            super(p);
        }

        @Override
        public final void compute() {
        }
    }
}

