/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UselessStringValueOfRule
extends AbstractJavaRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTMethodCall.class, (Class[])new Class[0]);
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (JavaAstUtils.isStringConcatExpr((JavaNode)node.getParent())) {
            ASTExpression valueOfArg = UselessStringValueOfRule.getValueOfArg(node);
            if (valueOfArg == null) {
                return data;
            }
            if (TypeTestUtil.isExactlyA(String.class, (TypeNode)valueOfArg)) {
                this.asCtx(data).addViolation((Node)node);
                return data;
            }
            ASTExpression sibling = JavaAstUtils.getOtherOperandIfInInfixExpr(node);
            if (TypeTestUtil.isExactlyA(String.class, (TypeNode)sibling) && !valueOfArg.getTypeMirror().isArray() && (UselessStringValueOfRule.getValueOfArg(sibling) == null || node.getIndexInParent() == 1)) {
                this.asCtx(data).addViolation((Node)node);
            }
        }
        return data;
    }

    private static @Nullable ASTExpression getValueOfArg(ASTExpression expr) {
        ASTMethodCall call;
        if (expr instanceof ASTMethodCall && (call = (ASTMethodCall)expr).getArguments().size() == 1 && "valueOf".equals(call.getMethodName()) && TypeTestUtil.isDeclaredInClass(String.class, call.getMethodType())) {
            return (ASTExpression)call.getArguments().get(0);
        }
        return null;
    }
}

