/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArguments;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypingContext;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UseDiamondOperatorRule
extends AbstractJavaRulechainRule {
    private static final String REPLACE_TYPE_ARGS_MESSAGE = "Explicit type arguments can be replaced by a diamond: `{0}`";
    private static final String RAW_TYPE_MESSAGE = "Raw type use may be avoided by using a diamond: `{0}`";
    private static final int MAX_ARGS_LENGTH = 25;

    public UseDiamondOperatorRule() {
        super(ASTConstructorCall.class, new Class[0]);
    }

    public Object visit(ASTConstructorCall ctorCall, Object data) {
        ASTClassType newTypeNode = ctorCall.getTypeNode();
        JTypeMirror newType = newTypeNode.getTypeMirror();
        ASTTypeArguments targs = newTypeNode.getTypeArguments();
        if (targs != null && targs.isDiamond() || TypeOps.isUnresolved(newType)) {
            return null;
        }
        if (!newType.isGeneric() || ctorCall.isAnonymousClass() && !UseDiamondOperatorRule.supportsDiamondOnAnonymousClass(ctorCall)) {
            return null;
        }
        if (UseDiamondOperatorRule.inferenceSucceedsWithoutTypeArgs(ctorCall)) {
            AbstractJavaNode reportNode = targs == null ? newTypeNode : targs;
            String message = targs == null ? RAW_TYPE_MESSAGE : REPLACE_TYPE_ARGS_MESSAGE;
            String replaceWith = UseDiamondOperatorRule.produceSuggestedExprImage(ctorCall);
            this.asCtx(data).addViolationWithMessage((Node)reportNode, message, new Object[]{replaceWith});
        }
        return null;
    }

    private static boolean supportsDiamondOnAnonymousClass(ASTConstructorCall ctorCall) {
        return ctorCall.getLanguageVersion().compareToVersion("9") >= 0;
    }

    private static boolean inferenceSucceedsWithoutTypeArgs(ASTConstructorCall call) {
        ExprContext topmostContext;
        ExprMirror.InvocationMirror mirror;
        ExprContext context = call.getConversionContext();
        if (context.isMissing()) {
            return false;
        }
        Infer infer = InternalApiBridge.getInferenceEntryPoint(call);
        JavaExprMirrors factory = JavaExprMirrors.forObservation(infer);
        InvocationNode invocContext = InternalApiBridge.getTopLevelExprContext(call).getInvocNodeIfInvocContext();
        if (invocContext == null) {
            ExprMirror.CtorInvocationMirror defaultMirror = (ExprMirror.CtorInvocationMirror)factory.getTopLevelInvocationMirror(call);
            mirror = new SpyInvocMirror(defaultMirror);
            topmostContext = call.getConversionContext();
        } else {
            mirror = factory.getInvocationMirror(invocContext, (e, parent, self) -> {
                ExprMirror defaultImpl = factory.defaultMirrorMaker().createMirrorForSubexpression(e, parent, self);
                if (e == call) {
                    return new SpyInvocMirror((ExprMirror.CtorInvocationMirror)defaultImpl);
                }
                return defaultImpl;
            });
            topmostContext = invocContext instanceof ASTExpression ? ((ASTExpression)((Object)invocContext)).getConversionContext() : ExprContext.getMissingInstance();
        }
        JTypeMirror targetType = topmostContext.getPolyTargetType(false);
        MethodCallSite fakeCallSite = infer.newCallSite(mirror, targetType);
        infer.inferInvocationRecursively(fakeCallSite);
        return mirror.isEquivalentToUnderlyingAst() && topmostContext.acceptsType(mirror.getInferredType());
    }

    private static String produceSuggestedExprImage(ASTConstructorCall ctor) {
        Chars text;
        StringBuilder sb = new StringBuilder(30);
        sb.append("new ");
        UseDiamondOperatorRule.produceSameTypeWithDiamond(ctor.getTypeNode(), sb, true);
        ASTArgumentList arguments = ctor.getArguments();
        String argsString = arguments.size() == 0 ? "()" : ((text = arguments.getText()).length() <= 25 && !StringUtils.contains((CharSequence)text, (int)10) ? text.toString() : "(...)");
        return sb.append(argsString).toString();
    }

    private static StringBuilder produceSameTypeWithDiamond(ASTClassType type, StringBuilder sb, boolean topLevel) {
        if (type.isFullyQualified()) {
            JTypeDeclSymbol sym = type.getTypeMirror().getSymbol();
            Objects.requireNonNull(sym);
            sb.append(sym.getPackageName()).append('.');
        } else {
            ASTClassType qualifier = type.getQualifier();
            if (qualifier != null) {
                UseDiamondOperatorRule.produceSameTypeWithDiamond(qualifier, sb, false).append('.');
            }
        }
        sb.append(type.getSimpleName());
        return topLevel ? sb.append("<>") : sb;
    }

    private static final class SpyInvocMirror
    implements ExprMirror.CtorInvocationMirror {
        private final ExprMirror.CtorInvocationMirror base;

        SpyInvocMirror(ExprMirror.CtorInvocationMirror base) {
            this.base = base;
        }

        @Override
        public @NonNull JTypeMirror getNewType() {
            return ((JClassType)this.base.getNewType()).getGenericTypeDeclaration();
        }

        @Override
        public boolean isDiamond() {
            return true;
        }

        @Override
        public List<JTypeMirror> getExplicitTypeArguments() {
            return this.base.getExplicitTypeArguments();
        }

        @Override
        public JavaNode getExplicitTargLoc(int i) {
            return this.base.getExplicitTargLoc(i);
        }

        @Override
        public void setInferredType(JTypeMirror mirror) {
            this.base.setInferredType(mirror);
        }

        @Override
        public JTypeMirror getInferredType() {
            return this.base.getInferredType();
        }

        @Override
        public void setCtDecl(ExprMirror.InvocationMirror.MethodCtDecl methodType) {
            this.base.setCtDecl(methodType);
        }

        @Override
        public @Nullable ExprMirror.InvocationMirror.MethodCtDecl getCtDecl() {
            return this.base.getCtDecl();
        }

        @Override
        public JavaNode getLocation() {
            return this.base.getLocation();
        }

        @Override
        public @NonNull JClassType getEnclosingType() {
            return this.base.getEnclosingType();
        }

        @Override
        public boolean isAnonymous() {
            return this.base.isAnonymous();
        }

        @Override
        public Iterable<JMethodSig> getAccessibleCandidates(JTypeMirror newType) {
            return this.base.getAccessibleCandidates(newType);
        }

        @Override
        public @Nullable JTypeMirror getReceiverType() {
            return this.base.getReceiverType();
        }

        @Override
        public String getName() {
            return this.base.getName();
        }

        @Override
        public List<ExprMirror> getArgumentExpressions() {
            return this.base.getArgumentExpressions();
        }

        @Override
        public int getArgumentCount() {
            return this.base.getArgumentCount();
        }

        public String toString() {
            return this.base.toString();
        }

        @Override
        public TypingContext getTypingContext() {
            return this.base.getTypingContext();
        }

        @Override
        public boolean isEquivalentToUnderlyingAst() {
            return this.base.isEquivalentToUnderlyingAst();
        }
    }
}

