/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Objects;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.ClassTypeImpl;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.Substitution;

public class JVariableSig {
    private final JVariableSymbol sym;
    private final JTypeMirror declarator;

    private JVariableSig(JTypeMirror declarator, JVariableSymbol sym) {
        assert (sym != null);
        assert (declarator != null);
        this.sym = sym;
        this.declarator = declarator;
    }

    public JTypeMirror getDeclaringType() {
        return this.declarator;
    }

    public JVariableSymbol getSymbol() {
        return this.sym;
    }

    public JTypeMirror getTypeMirror() {
        JTypeMirror symType;
        Substitution subst = this.declarator instanceof JClassType ? ((JClassType)this.declarator).getTypeParamSubst() : Substitution.EMPTY;
        JTypeMirror jTypeMirror = symType = this.declarator.isRaw() ? ClassTypeImpl.eraseToRaw(this.sym.getTypeMirror(Substitution.EMPTY), subst) : this.sym.getTypeMirror(subst);
        if (symType instanceof JWildcardType) {
            throw new IllegalStateException("Forgotten capture of " + this.declarator + " for symbol " + this.sym);
        }
        return symType;
    }

    static FieldSig forField(JTypeMirror declarator, JFieldSymbol sym) {
        return new FieldSig(declarator, sym);
    }

    static JVariableSig forLocal(JClassType declarator, JVariableSymbol sym) {
        return new JVariableSig(declarator, sym);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JVariableSig) || o.getClass() != this.getClass()) {
            return false;
        }
        JVariableSig that = (JVariableSig)o;
        return Objects.equals(this.sym, that.sym) && Objects.equals(this.declarator, that.declarator);
    }

    public int hashCode() {
        return Objects.hash(this.sym, this.declarator);
    }

    public String toString() {
        return "Signature of " + this.sym + " in " + this.declarator;
    }

    public static final class FieldSig
    extends JVariableSig {
        FieldSig(JTypeMirror declarator, JFieldSymbol sym) {
            super(declarator, sym);
        }

        @Override
        public JFieldSymbol getSymbol() {
            return (JFieldSymbol)((JVariableSig)this).sym;
        }
    }
}

