/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTAnonymousClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTCompactConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLabeledStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalClassStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.ASTPattern;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTResourceList;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.symbols.table.JSymbolTable;
import net.sourceforge.pmd.lang.java.symbols.table.internal.AbruptCompletionAnalysis;
import net.sourceforge.pmd.lang.java.symbols.table.internal.PatternBindingsUtil;
import net.sourceforge.pmd.lang.java.symbols.table.internal.ReferenceCtx;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SymTableFactory;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SymbolTableImpl;
import net.sourceforge.pmd.lang.java.types.JClassType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pcollections.PSet;

public final class SymbolTableResolver {
    private SymbolTableResolver() {
    }

    public static void traverse(JavaAstProcessor processor, ASTCompilationUnit root) {
        HashSet<DeferredNode> newDeferred;
        SymTableFactory helper = new SymTableFactory(root.getPackageName(), processor);
        ReferenceCtx ctx = ReferenceCtx.root(processor, root);
        Set<DeferredNode> todo = Collections.singleton(new DeferredNode(root, ctx, SymbolTableImpl.EMPTY));
        do {
            newDeferred = new HashSet<DeferredNode>();
            for (DeferredNode deferred : todo) {
                MyVisitor visitor = new MyVisitor(helper, todo, newDeferred);
                visitor.traverse(deferred);
            }
        } while (!(todo = newDeferred).isEmpty());
    }

    private static class MyVisitor
    extends JavaVisitorBase<ReferenceCtx, Void> {
        private final SymTableFactory f;
        private final Deque<JSymbolTable> stack = new ArrayDeque<JSymbolTable>();
        private final Deque<JClassType> enclosingType = new ArrayDeque<JClassType>();
        private final Set<DeferredNode> deferredInPrevRound;
        private final Set<DeferredNode> newDeferred;
        private final StatementVisitor stmtVisitor = new StatementVisitor();

        MyVisitor(SymTableFactory helper, Set<DeferredNode> deferredInPrevRound, Set<DeferredNode> newDeferred) {
            this.f = helper;
            this.deferredInPrevRound = deferredInPrevRound;
            this.newDeferred = newDeferred;
        }

        void traverse(DeferredNode task) {
            assert (this.stack.isEmpty()) : "Stack should be empty when starting the traversal";
            this.stack.push(task.localStackTop);
            task.node.acceptVisitor(this, task.enclosingCtx);
            JSymbolTable last = this.stack.pop();
            assert (last == task.localStackTop) : "Unbalanced stack push/pop! Started with " + task.localStackTop + ", finished on " + last;
        }

        @Override
        public Void visit(ASTClassType node, @NonNull ReferenceCtx data) {
            this.f.disambig((NodeStream<? extends JavaNode>)NodeStream.of((Node)node), data);
            return null;
        }

        @Override
        public Void visit(ASTAmbiguousName node, @NonNull ReferenceCtx data) {
            this.f.disambig((NodeStream<? extends JavaNode>)NodeStream.of((Node)node), data);
            return null;
        }

        @Override
        public Void visit(ASTModifierList node, @NonNull ReferenceCtx ctx) {
            return null;
        }

        @Override
        public Void visit(ASTCompilationUnit node, @NonNull ReferenceCtx ctx) {
            ArrayList<ASTImportDeclaration> importsOnDemand = new ArrayList<ASTImportDeclaration>();
            ArrayList<ASTImportDeclaration> singleImports = new ArrayList<ASTImportDeclaration>();
            ArrayList<ASTImportDeclaration> moduleImports = new ArrayList<ASTImportDeclaration>();
            node.children(ASTImportDeclaration.class).forEach(i -> {
                if (i.isModuleImport()) {
                    moduleImports.add((ASTImportDeclaration)i);
                } else if (i.isImportOnDemand()) {
                    importsOnDemand.add((ASTImportDeclaration)i);
                } else {
                    singleImports.add((ASTImportDeclaration)i);
                }
            });
            int pushed = 0;
            if (node.isSimpleCompilationUnit()) {
                pushed += this.pushOnStack(this.f.moduleImportJavaBase(this.top()));
                pushed += this.pushOnStack(this.f.importsOnDemandJavaIo(this.top()));
            }
            pushed += this.pushOnStack(this.f.moduleImports(this.top(), moduleImports));
            pushed += this.pushOnStack(this.f.importsOnDemand(this.top(), importsOnDemand));
            pushed += this.pushOnStack(this.f.javaLangSymTable(this.top()));
            pushed += this.pushOnStack(this.f.samePackageSymTable(this.top()));
            pushed += this.pushOnStack(this.f.singleImportsSymbolTable(this.top(), singleImports));
            NodeStream<ASTTypeDeclaration> typeDecls = node.getTypeDeclarations();
            pushed += this.pushOnStack(this.f.typesInFile(this.top(), typeDecls));
            this.setTopSymbolTable(node);
            for (ASTTypeDeclaration td : typeDecls) {
                this.processTypeHeader(td, ctx);
            }
            this.visitChildren((Node)node, ctx);
            this.popStack(pushed);
            return null;
        }

        private void processTypeHeader(ASTTypeDeclaration node, ReferenceCtx ctx) {
            this.setTopSymbolTable(node.getModifiers());
            int pushed = this.pushOnStack(this.f.selfType(this.top(), node.getTypeMirror()));
            pushed += this.pushOnStack(this.f.typeHeader(this.top(), node.getSymbol()));
            NodeStream notBody = node.children().drop(1).dropLast(1);
            for (JavaNode it : notBody) {
                this.setTopSymbolTable(it);
            }
            this.popStack(pushed - 1);
            this.f.disambig((NodeStream<? extends JavaNode>)notBody, ctx);
            this.setTopSymbolTable(node);
            this.popStack();
        }

        @Override
        public Void visitTypeDecl(ASTTypeDeclaration node, @NonNull ReferenceCtx ctx) {
            int pushed = 0;
            this.enclosingType.push(node.getTypeMirror());
            ReferenceCtx bodyCtx = ctx.scopeDownToNested(node.getSymbol());
            pushed += this.pushOnStack(this.f.typeBody(this.top(), node.getTypeMirror()));
            this.setTopSymbolTable(node.getBody());
            node.getDeclarations(ASTTypeDeclaration.class).forEach(d -> this.processTypeHeader((ASTTypeDeclaration)d, bodyCtx));
            this.f.disambig((NodeStream<? extends JavaNode>)node.getDeclarations(ASTFieldDeclaration.class).map(ASTFieldDeclaration::getTypeNode), bodyCtx);
            this.visitChildren((Node)node.getBody(), bodyCtx);
            this.enclosingType.pop();
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTAnonymousClassDeclaration node, @NonNull ReferenceCtx ctx) {
            DeferredNode deferredSpec;
            if (node.getParent() instanceof ASTConstructorCall && !this.deferredInPrevRound.contains(deferredSpec = new DeferredNode(node, ctx, this.top()))) {
                this.newDeferred.add(deferredSpec);
                return null;
            }
            return this.visitTypeDecl((ASTTypeDeclaration)node, ctx);
        }

        @Override
        public Void visitMethodOrCtor(ASTExecutableDeclaration node, @NonNull ReferenceCtx ctx) {
            this.setTopSymbolTable(node.getModifiers());
            int pushed = this.pushOnStack(this.f.bodyDeclaration(this.top(), this.enclosing(), node.getFormalParameters(), node.getTypeParameters()));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTInitializer node, @NonNull ReferenceCtx ctx) {
            int pushed = this.pushOnStack(this.f.bodyDeclaration(this.top(), this.enclosing(), null, null));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTCompactConstructorDeclaration node, @NonNull ReferenceCtx ctx) {
            this.setTopSymbolTable(node.getModifiers());
            int pushed = this.pushOnStack(this.f.recordCtor(this.top(), this.enclosing(), node.getSymbol()));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTLambdaExpression node, @NonNull ReferenceCtx ctx) {
            int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableId>)MyVisitor.formalsOf(node)));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTBlock node, @NonNull ReferenceCtx ctx) {
            int pushed = this.visitBlockLike(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTSwitchStatement node, @NonNull ReferenceCtx ctx) {
            return this.visitSwitch(node, ctx);
        }

        @Override
        public Void visit(ASTSwitchExpression node, @NonNull ReferenceCtx ctx) {
            return this.visitSwitch(node, ctx);
        }

        private Void visitSwitch(ASTSwitchLike node, @NonNull ReferenceCtx ctx) {
            this.setTopSymbolTable(node);
            node.getTestedExpression().acceptVisitor(this, ctx);
            int pushed = 0;
            for (ASTSwitchBranch branch : node.getBranches()) {
                ASTSwitchLabel label = branch.getLabel();
                PatternBindingsUtil.BindSet bindings = (PatternBindingsUtil.BindSet)label.children(ASTPattern.class).reduce((Object)PatternBindingsUtil.BindSet.EMPTY, (bindSet, pat) -> bindSet.union(PatternBindingsUtil.bindersOfPattern(pat)));
                this.setTopSymbolTableAndVisit(label, ctx);
                if (branch instanceof ASTSwitchArrowBranch) {
                    pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableId>)bindings.getTrueBindings()));
                    this.setTopSymbolTableAndVisit(((ASTSwitchArrowBranch)branch).getRightHandSide(), ctx);
                    this.popStack(pushed);
                    pushed = 0;
                    continue;
                }
                if (!(branch instanceof ASTSwitchFallthroughBranch)) continue;
                pushed += this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableId>)bindings.getTrueBindings()));
                pushed += this.visitBlockLike((Iterable<? extends JavaNode>)((ASTSwitchFallthroughBranch)branch).getStatements(), ctx);
            }
            this.popStack(pushed);
            return null;
        }

        private int visitBlockLike(Iterable<? extends JavaNode> node, @NonNull ReferenceCtx ctx) {
            int pushed = 0;
            for (JavaNode javaNode : node) {
                if (javaNode instanceof ASTLocalVariableDeclaration) {
                    pushed += this.processLocalVarDecl((ASTLocalVariableDeclaration)javaNode, ctx);
                } else if (javaNode instanceof ASTLocalClassStatement) {
                    ASTTypeDeclaration local = ((ASTLocalClassStatement)javaNode).getDeclaration();
                    pushed += this.pushOnStack(this.f.localTypeSymTable(this.top(), local.getTypeMirror()));
                    this.processTypeHeader(local, ctx);
                }
                if (javaNode instanceof ASTStatement) {
                    this.setTopSymbolTable(javaNode);
                    PSet newVars = (PSet)javaNode.acceptVisitor(this.stmtVisitor, ctx);
                    pushed += this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableId>)newVars));
                    continue;
                }
                assert (javaNode instanceof ASTExpression && javaNode.getParent() instanceof ASTResource) : javaNode;
                this.setTopSymbolTable((JavaNode)javaNode.getParent());
                javaNode.acceptVisitor(this, ctx);
            }
            return pushed;
        }

        private int processLocalVarDecl(ASTLocalVariableDeclaration st, @NonNull ReferenceCtx ctx) {
            int pushed = 0;
            for (ASTVariableDeclarator declarator : st.children(ASTVariableDeclarator.class)) {
                ASTVariableId varId = declarator.getVarId();
                pushed += this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), varId));
                this.setTopSymbolTableAndVisit(declarator.getInitializer(), ctx);
            }
            return pushed;
        }

        @Override
        public Void visit(ASTForeachStatement node, @NonNull ReferenceCtx ctx) {
            this.setTopSymbolTableAndVisit(node.getIterableExpr(), ctx);
            ASTVariableId varId = node.getVarId();
            this.setTopSymbolTableAndVisit(varId.getTypeNode(), ctx);
            int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), varId));
            ASTStatement body = node.getBody();
            this.setTopSymbolTableAndVisit(body, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTTryStatement node, @NonNull ReferenceCtx ctx) {
            ASTResourceList resources = node.getResources();
            if (resources != null) {
                NodeStream union = NodeStream.union((NodeStream[])new NodeStream[]{MyVisitor.stmtsOfResources(resources), NodeStream.of((Node)node.getBody())});
                this.popStack(this.visitBlockLike((Iterable<? extends JavaNode>)union, ctx));
                for (Node child : node.getBody().asStream().followingSiblings()) {
                    child.acceptVisitor((AstVisitor)this, (Object)ctx);
                }
            } else {
                this.visitChildren((Node)node, ctx);
            }
            return null;
        }

        @Override
        public Void visit(ASTCatchClause node, @NonNull ReferenceCtx ctx) {
            int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), node.getParameter().getVarId()));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTInfixExpression node, @NonNull ReferenceCtx ctx) {
            PSet<ASTVariableId> falseBindings;
            node.getLeftOperand().acceptVisitor(this, ctx);
            BinaryOp op = node.getOperator();
            if (op == BinaryOp.CONDITIONAL_AND) {
                PSet<ASTVariableId> trueBindings = PatternBindingsUtil.bindersOfExpr(node.getLeftOperand()).getTrueBindings();
                if (!trueBindings.isEmpty()) {
                    int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableId>)trueBindings));
                    this.setTopSymbolTableAndVisit(node.getRightOperand(), ctx);
                    this.popStack(pushed);
                    return null;
                }
            } else if (op == BinaryOp.CONDITIONAL_OR && !(falseBindings = PatternBindingsUtil.bindersOfExpr(node.getLeftOperand()).getFalseBindings()).isEmpty()) {
                int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableId>)falseBindings));
                this.setTopSymbolTableAndVisit(node.getRightOperand(), ctx);
                this.popStack(pushed);
                return null;
            }
            return (Void)node.getRightOperand().acceptVisitor(this, ctx);
        }

        @Override
        public Void visit(ASTConditionalExpression node, @NonNull ReferenceCtx ctx) {
            ASTExpression condition = node.getCondition();
            condition.acceptVisitor(this, ctx);
            PatternBindingsUtil.BindSet binders = PatternBindingsUtil.bindersOfExpr(condition);
            if (binders.isEmpty()) {
                node.getThenBranch().acceptVisitor(this, ctx);
                node.getElseBranch().acceptVisitor(this, ctx);
            } else {
                int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableId>)binders.getTrueBindings()));
                this.setTopSymbolTableAndVisit(node.getThenBranch(), ctx);
                this.popStack(pushed);
                pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableId>)binders.getFalseBindings()));
                this.setTopSymbolTableAndVisit(node.getElseBranch(), ctx);
                this.popStack(pushed);
            }
            return null;
        }

        private void setTopSymbolTable(JavaNode node) {
            InternalApiBridge.setSymbolTable(node, this.top());
        }

        private JClassType enclosing() {
            if (this.enclosingType.isEmpty()) {
                return null;
            }
            return this.enclosingType.getFirst();
        }

        private void setTopSymbolTableAndVisitAllChildren(JavaNode node, @NonNull ReferenceCtx ctx) {
            if (node == null) {
                return;
            }
            this.setTopSymbolTable(node);
            this.visitChildren((Node)node, ctx);
        }

        private void setTopSymbolTableAndVisit(JavaNode node, @NonNull ReferenceCtx ctx) {
            if (node == null) {
                return;
            }
            this.setTopSymbolTable(node);
            node.acceptVisitor(this, ctx);
        }

        private int pushOnStack(JSymbolTable table) {
            if (table == this.top()) {
                return 0;
            }
            this.stack.push(table);
            return 1;
        }

        private JSymbolTable popStack() {
            return this.stack.pop();
        }

        private void popStack(int times) {
            assert (this.stack.size() > times) : "Stack is too small (" + times + ") " + this.stack;
            while (times-- > 0) {
                this.popStack();
            }
        }

        private JSymbolTable top() {
            return this.stack.getFirst();
        }

        static NodeStream<JavaNode> stmtsOfResources(ASTResourceList node) {
            return node.toStream().map(GenericNode::getFirstChild);
        }

        static NodeStream<ASTVariableId> formalsOf(ASTLambdaExpression node) {
            return node.getParameters().toStream().map(ASTLambdaParameter::getVarId);
        }

        class StatementVisitor
        extends JavaVisitorBase<ReferenceCtx, PSet<ASTVariableId>> {
            StatementVisitor() {
            }

            @Override
            public PSet<ASTVariableId> visitJavaNode(JavaNode node, ReferenceCtx ctx) {
                throw new IllegalStateException("I only expect statements, got " + node);
            }

            @Override
            public PSet<ASTVariableId> visitStatement(ASTStatement node, ReferenceCtx ctx) {
                node.acceptVisitor(MyVisitor.this, ctx);
                return PatternBindingsUtil.BindSet.noBindings();
            }

            @Override
            public PSet<ASTVariableId> visit(ASTLabeledStatement node, @NonNull ReferenceCtx ctx) {
                return (PSet)node.getStatement().acceptVisitor(this, ctx);
            }

            @Override
            public PSet<ASTVariableId> visit(ASTIfStatement node, ReferenceCtx ctx) {
                PatternBindingsUtil.BindSet bindSet = PatternBindingsUtil.bindersOfExpr(node.getCondition());
                ASTStatement thenBranch = node.getThenBranch();
                ASTStatement elseBranch = node.getElseBranch();
                MyVisitor.this.setTopSymbolTableAndVisit(node.getCondition(), ctx);
                int pushed = MyVisitor.this.pushOnStack(MyVisitor.this.f.localVarSymTable(MyVisitor.this.top(), MyVisitor.this.enclosing(), (Iterable<ASTVariableId>)bindSet.getTrueBindings()));
                this.setTopSymbolTableAndVisit(thenBranch, ctx);
                MyVisitor.this.popStack(pushed);
                if (elseBranch != null) {
                    pushed = MyVisitor.this.pushOnStack(MyVisitor.this.f.localVarSymTable(MyVisitor.this.top(), MyVisitor.this.enclosing(), (Iterable<ASTVariableId>)bindSet.getFalseBindings()));
                    this.setTopSymbolTableAndVisit(elseBranch, ctx);
                    MyVisitor.this.popStack(pushed);
                }
                if (!bindSet.isEmpty()) {
                    boolean elseCanCompleteNormally;
                    boolean thenCanCompleteNormally = AbruptCompletionAnalysis.canCompleteNormally(thenBranch);
                    boolean bl = elseCanCompleteNormally = elseBranch == null || AbruptCompletionAnalysis.canCompleteNormally(elseBranch);
                    if (thenCanCompleteNormally && !elseCanCompleteNormally) {
                        return bindSet.getTrueBindings();
                    }
                    if (!thenCanCompleteNormally && elseCanCompleteNormally) {
                        return bindSet.getFalseBindings();
                    }
                }
                return PatternBindingsUtil.BindSet.noBindings();
            }

            @Override
            public PSet<ASTVariableId> visit(ASTWhileStatement node, ReferenceCtx ctx) {
                PatternBindingsUtil.BindSet bindSet = PatternBindingsUtil.bindersOfExpr(node.getCondition());
                MyVisitor.this.setTopSymbolTableAndVisit(node.getCondition(), ctx);
                int pushed = MyVisitor.this.pushOnStack(MyVisitor.this.f.localVarSymTable(MyVisitor.this.top(), MyVisitor.this.enclosing(), (Iterable<ASTVariableId>)NodeStream.fromIterable(bindSet.getTrueBindings())));
                this.setTopSymbolTableAndVisit(node.getBody(), ctx);
                MyVisitor.this.popStack(pushed);
                if (this.hasNoBreakContainingStmt(node)) {
                    return bindSet.getFalseBindings();
                }
                return PatternBindingsUtil.BindSet.noBindings();
            }

            @Override
            public PSet<ASTVariableId> visit(ASTForStatement node, @NonNull ReferenceCtx ctx) {
                int pushed = 0;
                ASTStatement init = node.getInit();
                if (init instanceof ASTLocalVariableDeclaration) {
                    pushed += MyVisitor.this.processLocalVarDecl((ASTLocalVariableDeclaration)init, ctx);
                } else {
                    this.setTopSymbolTableAndVisit(init, ctx);
                }
                ASTExpression condition = node.getCondition();
                MyVisitor.this.setTopSymbolTableAndVisit(node.getCondition(), ctx);
                PatternBindingsUtil.BindSet bindSet = PatternBindingsUtil.bindersOfExpr(condition);
                this.setTopSymbolTableAndVisit(node.getUpdate(), ctx);
                this.setTopSymbolTableAndVisit(node.getBody(), ctx);
                MyVisitor.this.popStack(pushed += MyVisitor.this.pushOnStack(MyVisitor.this.f.localVarSymTable(MyVisitor.this.top(), MyVisitor.this.enclosing(), (Iterable<ASTVariableId>)bindSet.getTrueBindings())));
                if (bindSet.getFalseBindings().isEmpty()) {
                    return PatternBindingsUtil.BindSet.noBindings();
                }
                if (this.hasNoBreakContainingStmt(node)) {
                    return bindSet.getFalseBindings();
                }
                return PatternBindingsUtil.BindSet.noBindings();
            }

            private boolean hasNoBreakContainingStmt(ASTLoopStatement node) {
                Set containingStatements = (Set)node.ancestorsOrSelf().filter(JavaAstUtils::mayBeBreakTarget).collect(Collectors.toSet());
                return node.getBody().descendants(ASTBreakStatement.class).none(it -> containingStatements.contains(it.getTarget()));
            }

            private void setTopSymbolTableAndVisitAllChildren(JavaNode node, @NonNull ReferenceCtx ctx) {
                if (node == null) {
                    return;
                }
                MyVisitor.this.setTopSymbolTable(node);
                this.visitChildren((Node)node, ctx);
            }

            private void setTopSymbolTableAndVisit(JavaNode node, @NonNull ReferenceCtx ctx) {
                if (node == null) {
                    return;
                }
                MyVisitor.this.setTopSymbolTable(node);
                node.acceptVisitor(this, ctx);
            }
        }
    }

    private static final class DeferredNode {
        final JavaNode node;
        final ReferenceCtx enclosingCtx;
        final JSymbolTable localStackTop;

        private DeferredNode(JavaNode node, ReferenceCtx enclosingCtx, JSymbolTable localStackTop) {
            this.node = node;
            this.enclosingCtx = enclosingCtx;
            this.localStackTop = localStackTop;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeferredNode that = (DeferredNode)o;
            return this.node.equals(that.node);
        }

        public int hashCode() {
            return Objects.hash(this.node);
        }
    }
}

