/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.coreimpl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.NameResolver;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainNode;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainNodeBase;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;

class CachingShadowChainNode<S, I>
extends ShadowChainNodeBase<S, I> {
    private final Map<String, List<S>> cache;
    private final Map<String, OptionalBool> keysThatIKnow = new HashMap<String, OptionalBool>();

    protected CachingShadowChainNode(@NonNull ShadowChainNode<S, I> parent, Map<String, List<S>> known, NameResolver<? extends S> resolver, boolean shadowBarrier, I scopeTag, BinaryOperator<List<S>> merger) {
        super(parent, shadowBarrier, scopeTag, resolver, merger);
        this.cache = known;
    }

    @Override
    public @NonNull List<S> resolve(String name) {
        List<S> result = this.cache.get(name);
        if (result != null) {
            return result;
        }
        result = super.resolve(name);
        this.cache.put(name, result);
        return result;
    }

    @Override
    protected void handleResolverKnows(String name, boolean resolverKnows) {
        this.keysThatIKnow.putIfAbsent(name, OptionalBool.definitely((boolean)resolverKnows));
    }

    @Override
    public S resolveFirst(String name) {
        List<S> result = this.cache.get(name);
        if (result != null && !result.isEmpty()) {
            return result.get(0);
        }
        Object first = super.resolveFirst(name);
        if (first == null) {
            this.cache.put(name, Collections.emptyList());
        } else if (this.resolver instanceof NameResolver.SingleNameResolver && this.isShadowBarrier()) {
            this.cache.put(name, Collections.singletonList(first));
        }
        return first;
    }

    @Override
    public OptionalBool knowsSymbol(String simpleName) {
        OptionalBool resolverKnows = this.resolver.knows(simpleName);
        if (resolverKnows.isKnown()) {
            return resolverKnows;
        }
        return this.keysThatIKnow.getOrDefault(simpleName, OptionalBool.UNKNOWN);
    }

    @Override
    public String toString() {
        return "Cached(cache size=" + this.cache.size() + ", resolver=" + super.toString() + ')';
    }
}

