/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.util.CollectionUtil;

public final class GetModifiersFun
extends BaseJavaXPathFunction {
    private final boolean explicit;
    public static final GetModifiersFun GET_EFFECTIVE = new GetModifiersFun("modifiers", false);
    public static final GetModifiersFun GET_EXPLICIT = new GetModifiersFun("explicitModifiers", true);

    private GetModifiersFun(String localName, boolean explicit) {
        super(localName);
        this.explicit = explicit;
    }

    public XPathFunctionDefinition.Type getResultType() {
        return XPathFunctionDefinition.Type.STRING_SEQUENCE;
    }

    public boolean dependsOnContext() {
        return true;
    }

    public XPathFunctionDefinition.FunctionCall makeCallExpression() {
        return (contextNode, arguments) -> {
            if (contextNode instanceof ModifierOwner) {
                ASTModifierList modList = ((ModifierOwner)contextNode).getModifiers();
                Set<JModifier> mods = this.explicit ? modList.getExplicitModifiers() : modList.getEffectiveModifiers();
                return CollectionUtil.map(mods, JModifier::getToken);
            }
            return Collections.emptyList();
        };
    }
}

