/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.QualifiableExpression;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.StablePathMatcher;
import net.sourceforge.pmd.reporting.RuleContext;

public class BrokenNullCheckRule
extends AbstractJavaRulechainRule {
    public BrokenNullCheckRule() {
        super(ASTInfixExpression.class, new Class[0]);
    }

    public Object visit(ASTInfixExpression node, Object data) {
        this.checkBrokenNullCheck(node, (RuleContext)data);
        return data;
    }

    private void checkBrokenNullCheck(ASTInfixExpression enclosingConditional, RuleContext ctx) {
        ASTExpression left = enclosingConditional.getLeftOperand();
        if (!(left instanceof ASTInfixExpression)) {
            return;
        }
        BinaryOp op = ((ASTInfixExpression)left).getOperator();
        if (op != BinaryOp.EQ && op != BinaryOp.NE) {
            return;
        }
        if (op == BinaryOp.NE && enclosingConditional.getOperator() == BinaryOp.CONDITIONAL_AND || op == BinaryOp.EQ && enclosingConditional.getOperator() == BinaryOp.CONDITIONAL_OR) {
            return;
        }
        ASTNullLiteral nullLit = (ASTNullLiteral)left.children(ASTNullLiteral.class).first();
        if (nullLit == null) {
            return;
        }
        ASTExpression otherChild = JavaAstUtils.getOtherOperandIfInInfixExpr(nullLit);
        StablePathMatcher pathToNullVar = StablePathMatcher.matching(otherChild);
        if (pathToNullVar == null) {
            return;
        }
        NodeStream exprsToCheck = enclosingConditional.getRightOperand().descendantsOrSelf().filterIs(ASTExpression.class);
        for (ASTExpression subexpr : exprsToCheck) {
            NpeReason npeReason = BrokenNullCheckRule.willNpeWithReason(subexpr, pathToNullVar);
            if (npeReason == null) continue;
            ctx.addViolationWithMessage((Node)subexpr, npeReason.formatMessage);
        }
    }

    private static NpeReason willNpeWithReason(ASTExpression e, StablePathMatcher pathToNullVar) {
        ASTExpression qualifier;
        if (e instanceof QualifiableExpression && pathToNullVar.matches(qualifier = ((QualifiableExpression)e).getQualifier())) {
            return NpeReason.DEREFERENCE;
        }
        if (e.getParent() instanceof ASTInfixExpression) {
            ASTInfixExpression infix = (ASTInfixExpression)e.getParent();
            if (pathToNullVar.matches(e) && BrokenNullCheckRule.operatorUnboxesOperand(infix)) {
                return NpeReason.UNBOXING;
            }
        }
        return null;
    }

    private static boolean operatorUnboxesOperand(ASTInfixExpression infix) {
        boolean rightIsPrimitive;
        BinaryOp operator = infix.getOperator();
        if (operator == BinaryOp.INSTANCEOF) {
            return false;
        }
        boolean leftIsPrimitive = infix.getLeftOperand().getTypeMirror().isPrimitive();
        if (leftIsPrimitive != (rightIsPrimitive = infix.getRightOperand().getTypeMirror().isPrimitive())) {
            return true;
        }
        assert (!leftIsPrimitive || !rightIsPrimitive) : "We know at least one of the operands is null";
        return operator != BinaryOp.NE && operator != BinaryOp.EQ;
    }

    static enum NpeReason {
        DEREFERENCE("Dereferencing the qualifier of this expression will throw a NullPointerException"),
        UNBOXING("Unboxing this operand will throw a NullPointerException");

        private final String formatMessage;

        private NpeReason(String formatMessage) {
            this.formatMessage = formatMessage;
        }
    }
}

