/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTArrayType;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTModuleProvidesDirective;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class LooseCouplingRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<List<String>> ALLOWED_TYPES = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"allowedTypes").desc("Exceptions to the rule")).defaultValues((Object)"java.util.Properties", (Object[])new String[0]).build();

    public LooseCouplingRule() {
        super(ASTClassType.class, new Class[0]);
        this.definePropertyDescriptor(ALLOWED_TYPES);
    }

    public Object visit(ASTClassType node, Object data) {
        if (!(!this.isConcreteCollectionType(node) || LooseCouplingRule.isInOverriddenMethodSignature(node) || this.isInAllowedSyntacticCtx(node) || this.isAllowedType(node) || this.isTypeParameter(node))) {
            this.asCtx(data).addViolation((Node)node, new Object[]{node.getSimpleName()});
        }
        return null;
    }

    private boolean isInAllowedSyntacticCtx(ASTClassType node) {
        JavaNode parent = (JavaNode)node.getParent();
        return parent instanceof ASTConstructorCall || parent instanceof ASTTypeExpression || parent instanceof ASTCastExpression || parent instanceof ASTClassLiteral || parent instanceof ASTClassType || parent instanceof ASTExtendsList || parent instanceof ASTThisExpression || parent instanceof ASTSuperExpression || parent instanceof ASTModuleProvidesDirective || parent instanceof ASTArrayType && parent.getParent() instanceof ASTArrayAllocation;
    }

    private boolean isAllowedType(ASTClassType node) {
        for (String allowed : (List)this.getProperty(ALLOWED_TYPES)) {
            if (!TypeTestUtil.isA(allowed, (TypeNode)node)) continue;
            return true;
        }
        return false;
    }

    private boolean isConcreteCollectionType(ASTClassType node) {
        return (TypeTestUtil.isA(Collection.class, (TypeNode)node) || TypeTestUtil.isA(Map.class, (TypeNode)node)) && !node.getTypeMirror().isInterface();
    }

    private static boolean isInOverriddenMethodSignature(JavaNode node) {
        JavaNode ancestor = (JavaNode)node.ancestors().map(NodeStream.asInstanceOf(ASTMethodDeclaration.class, (Class[])new Class[]{ASTBlock.class})).first();
        return ancestor instanceof ASTMethodDeclaration && ((ASTMethodDeclaration)ancestor).isOverridden();
    }

    private boolean isTypeParameter(ASTClassType node) {
        return node.getTypeMirror().isTypeVariable();
    }
}

