/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.bestpractices.AccessorMethodGenerationRule;
import net.sourceforge.pmd.reporting.RuleContext;

public class AccessorClassGenerationRule
extends AbstractJavaRulechainRule {
    private final Set<JavaNode> reportedNodes = new HashSet<JavaNode>();

    public AccessorClassGenerationRule() {
        super(ASTConstructorCall.class, ASTExplicitConstructorInvocation.class);
    }

    public void end(RuleContext ctx) {
        super.end(ctx);
        this.reportedNodes.clear();
    }

    public Object visit(ASTConstructorCall node, Object data) {
        if (!node.isAnonymousClass()) {
            AccessorMethodGenerationRule.checkMemberAccess((RuleContext)data, node, node.getMethodType().getSymbol(), this.reportedNodes);
        }
        return null;
    }

    public Object visit(ASTExplicitConstructorInvocation node, Object data) {
        if (node.isSuper()) {
            AccessorMethodGenerationRule.checkMemberAccess((RuleContext)data, node, node.getMethodType().getSymbol(), this.reportedNodes);
        }
        return null;
    }
}

