/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.internal;

import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.internal.JavaLanguageProcessor;
import net.sourceforge.pmd.lang.java.internal.JavaLanguageProperties;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.UnresolvedClassStore;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.SymbolResolutionPass;
import net.sourceforge.pmd.lang.java.symbols.table.internal.ReferenceCtx;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SymbolTableResolver;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.infer.TypeInferenceLogger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavaAstProcessor {
    private final TypeInferenceLogger typeInferenceLogger;
    private final JavaLanguageProcessor globalProc;
    private final SemanticErrorReporter logger;
    private SymbolResolver symResolver;
    private final UnresolvedClassStore unresolvedTypes;
    private final ASTCompilationUnit acu;

    private JavaAstProcessor(JavaLanguageProcessor globalProc, SemanticErrorReporter logger, TypeInferenceLogger typeInfLogger, ASTCompilationUnit acu) {
        this.symResolver = globalProc.getTypeSystem().bootstrapResolver();
        this.globalProc = globalProc;
        this.logger = logger;
        this.typeInferenceLogger = typeInfLogger;
        this.unresolvedTypes = new UnresolvedClassStore(globalProc.getTypeSystem());
        this.acu = acu;
    }

    public boolean hasFirstClassLombokSupport() {
        return this.globalProc.hasFirstClassLombokSupport();
    }

    public UnresolvedClassStore getUnresolvedStore() {
        return this.unresolvedTypes;
    }

    public @NonNull JClassSymbol findSymbolCannotFail(String name) {
        return this.findSymbolCannotFail(null, name);
    }

    public @NonNull JClassSymbol findSymbolCannotFail(@Nullable JavaNode location, String canoName) {
        JClassSymbol found = this.getSymResolver().resolveClassFromCanonicalName(canoName);
        if (found == null) {
            if (location != null) {
                this.reportCannotResolveSymbol(location, canoName);
            }
            return this.makeUnresolvedReference(canoName, 0);
        }
        return found;
    }

    public void reportCannotResolveSymbol(@NonNull JavaNode location, String canoName) {
        this.getLogger().warning((Node)location, "Cannot resolve symbol {0}", new Object[]{canoName});
    }

    public JClassSymbol makeUnresolvedReference(String canonicalName, int typeArity) {
        return this.unresolvedTypes.makeUnresolvedReference(canonicalName, typeArity);
    }

    public JClassSymbol makeUnresolvedReference(JTypeDeclSymbol outer, String simpleName, int typeArity) {
        if (outer instanceof JClassSymbol) {
            return this.unresolvedTypes.makeUnresolvedReference((JClassSymbol)outer, simpleName, typeArity);
        }
        return this.makeUnresolvedReference("error." + simpleName, typeArity);
    }

    public SymbolResolver getSymResolver() {
        return this.symResolver;
    }

    public SemanticErrorReporter getLogger() {
        return this.logger;
    }

    public int getJdkVersion() {
        return JavaLanguageProperties.getInternalJdkVersion(this.acu.getLanguageVersion());
    }

    public void process() {
        SymbolResolver knownSyms = (SymbolResolver)TimeTracker.bench((String)"Symbol resolution", () -> SymbolResolutionPass.traverse(this, this.acu));
        this.symResolver = SymbolResolver.layer(knownSyms, this.symResolver);
        InternalApiBridge.initTypeResolver(this.acu, this, this.typeInferenceLogger);
        TimeTracker.bench((String)"Symbol table resolution", () -> SymbolTableResolver.traverse(this, this.acu));
        TimeTracker.bench((String)"AST disambiguation", () -> InternalApiBridge.disambigWithCtx((NodeStream<? extends JavaNode>)NodeStream.of((Node)this.acu), ReferenceCtx.root(this, this.acu)));
        if (((Boolean)((JavaLanguageProperties)this.globalProc.getProperties()).getProperty(JavaLanguageProperties.INTERNAL_DO_STRICT_TYPERES)).booleanValue()) {
            TimeTracker.bench((String)"Force type resolution", () -> InternalApiBridge.forceTypeResolutionPhase(this, this.acu));
        }
        TimeTracker.bench((String)"Comment assignment", () -> InternalApiBridge.assignComments(this.acu));
        TimeTracker.bench((String)"Usage resolution", () -> InternalApiBridge.usageResolution(this, this.acu));
        TimeTracker.bench((String)"Override resolution", () -> InternalApiBridge.overrideResolution(this, this.acu));
    }

    public TypeSystem getTypeSystem() {
        return this.globalProc.getTypeSystem();
    }

    public static void process(JavaLanguageProcessor globalProcessor, SemanticErrorReporter semanticErrorReporter, ASTCompilationUnit ast) {
        JavaAstProcessor.process(globalProcessor, semanticErrorReporter, globalProcessor.newTypeInfLogger(), ast);
    }

    public static void process(JavaLanguageProcessor globalProcessor, SemanticErrorReporter semanticErrorReporter, TypeInferenceLogger typeInfLogger, ASTCompilationUnit ast) {
        JavaAstProcessor astProc = new JavaAstProcessor(globalProcessor, semanticErrorReporter, typeInfLogger, ast);
        astProc.process();
    }
}

