/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.FakeIntersectionSymbol;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.Lub;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

public final class JIntersectionType
implements JTypeMirror {
    private final TypeSystem ts;
    private final JTypeMirror primaryBound;
    private final List<JTypeMirror> components;
    private JClassType induced;

    JIntersectionType(TypeSystem ts, JTypeMirror primaryBound, List<? extends JTypeMirror> allBounds) {
        this.primaryBound = primaryBound;
        this.components = Collections.unmodifiableList(allBounds);
        this.ts = ts;
        assert (Lub.isExclusiveIntersectionBound(primaryBound)) : "Wrong primary intersection bound: " + JIntersectionType.toString(primaryBound, allBounds);
        assert (primaryBound != ts.OBJECT || allBounds.size() > 1) : "Intersection of a single bound: " + JIntersectionType.toString(primaryBound, allBounds);
        JIntersectionType.checkWellFormed(primaryBound, allBounds);
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
        return HashTreePSet.empty();
    }

    @Override
    public JTypeMirror withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
        return new JIntersectionType(this.ts, this.primaryBound.withAnnotations(newTypeAnnots), CollectionUtil.map(this.components, c -> c.withAnnotations(newTypeAnnots)));
    }

    public List<JTypeMirror> getComponents() {
        return this.components;
    }

    public @NonNull JTypeMirror getPrimaryBound() {
        return this.primaryBound;
    }

    public @NonNull List<JClassType> getInterfaces() {
        return this.primaryBound == this.ts.OBJECT ? this.components : this.components.subList(1, this.components.size());
    }

    public @Nullable JClassType getInducedClassType() {
        JTypeMirror primary = this.getPrimaryBound();
        if (primary instanceof JTypeVar || primary instanceof JArrayType) {
            return null;
        }
        if (this.induced == null) {
            FakeIntersectionSymbol sym = new FakeIntersectionSymbol("", (JClassType)primary, this.getInterfaces());
            this.induced = (JClassType)this.ts.declaration(sym);
        }
        return this.induced;
    }

    @Override
    public <T, P> T acceptVisitor(JTypeVisitor<T, P> visitor, P p) {
        return visitor.visitIntersection(this, p);
    }

    @Override
    public Stream<JMethodSig> streamMethods(Predicate<? super JMethodSymbol> prefilter) {
        return this.getComponents().stream().flatMap(it -> it.streamMethods(prefilter));
    }

    @Override
    public JIntersectionType subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        JTypeVisitable newPrimary = this.primaryBound.subst((Function)subst);
        List<JClassType> myItfs = this.getInterfaces();
        List<JClassType> newBounds = TypeOps.substClasses(myItfs, subst);
        return newPrimary == this.getPrimaryBound() && newBounds == myItfs ? this : new JIntersectionType(this.ts, (JTypeMirror)newPrimary, newBounds);
    }

    @Override
    public @Nullable JTypeDeclSymbol getSymbol() {
        return null;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public JTypeMirror getErasure() {
        return this.getPrimaryBound().getErasure();
    }

    @Override
    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JIntersectionType)) {
            return false;
        }
        JIntersectionType that = (JIntersectionType)o;
        return TypeOps.isSameType(this, that);
    }

    public int hashCode() {
        return Objects.hash(this.components);
    }

    private static void checkWellFormed(JTypeMirror primary, List<? extends JTypeMirror> flattened) {
        assert (flattened.get(0) == primary || primary == primary.getTypeSystem().OBJECT) : "Not a well-formed intersection " + flattened;
        for (int i = 0; i < flattened.size(); ++i) {
            JTypeMirror ci = flattened.get(i);
            Objects.requireNonNull(ci, "Null intersection component");
            if (Lub.isExclusiveIntersectionBound(ci)) {
                if (i == 0) continue;
                throw JIntersectionType.malformedIntersection(primary, flattened);
            }
            if (ci instanceof JClassType) {
                assert (ci.isInterface() || TypeOps.hasUnresolvedSymbol(ci));
                continue;
            }
            throw JIntersectionType.malformedIntersection(primary, flattened);
        }
    }

    private static RuntimeException malformedIntersection(JTypeMirror primary, List<? extends JTypeMirror> flattened) {
        return new IllegalArgumentException("Malformed intersection: " + JIntersectionType.toString(primary, flattened));
    }

    private static String toString(JTypeMirror primary, List<? extends JTypeMirror> flattened) {
        return flattened.stream().map(JTypeMirror::toString).collect(Collectors.joining(" & ", primary.toString() + " & ", ""));
    }
}

