/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.ast;

import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTReceiverParameter;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFormalParamSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AbstractAstTParamOwner;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstFormalParamSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstSymFactory;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractAstExecSymbol<T extends ASTExecutableDeclaration>
extends AbstractAstTParamOwner<T>
implements JExecutableSymbol {
    private final JClassSymbol owner;
    private final List<JFormalParamSymbol> formals;

    protected AbstractAstExecSymbol(T node, AstSymFactory factory, JClassSymbol owner) {
        super(node, factory);
        this.owner = owner;
        this.formals = CollectionUtil.map((Iterable)node.getFormalParameters(), p -> new AstFormalParamSym(p.getVarId(), factory, this));
    }

    @Override
    public List<JFormalParamSymbol> getFormalParameters() {
        return this.formals;
    }

    @Override
    public List<JTypeMirror> getFormalParameterTypes(Substitution subst) {
        return CollectionUtil.map(this.getFormalParameters(), i -> i.getTypeMirror(subst));
    }

    @Override
    public List<JTypeMirror> getThrownExceptionTypes(Substitution subst) {
        return CollectionUtil.map(ASTList.orEmpty(((ASTExecutableDeclaration)this.node).getThrowsList()), t -> t.getTypeMirror().subst((Function)subst));
    }

    @Override
    public @Nullable JTypeMirror getAnnotatedReceiverType(Substitution subst) {
        if (!this.hasReceiver()) {
            return null;
        }
        ASTReceiverParameter receiver = ((ASTExecutableDeclaration)this.node).getFormalParameters().getReceiverParameter();
        if (receiver == null) {
            return this.getTypeSystem().declaration(this.getEnclosingClass()).subst((Function)subst);
        }
        return receiver.getReceiverType().getTypeMirror().subst((Function)subst);
    }

    @Override
    public @NonNull JClassSymbol getEnclosingClass() {
        return this.owner;
    }

    @Override
    public boolean isVarargs() {
        return ((ASTExecutableDeclaration)this.node).isVarargs();
    }

    @Override
    public int getArity() {
        return this.formals.size();
    }
}

