/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AnnotationOwner;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SymbolicAnnotationImpl;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.SymbolicValueBuilder;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeAnnotationReceiver;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.TypePath;

class AnnotationBuilderVisitor
extends SymbolicValueBuilder {
    final SymbolicAnnotationImpl annot;
    private final AnnotationOwner owner;

    AnnotationBuilderVisitor(AnnotationOwner owner, AsmSymbolResolver resolver, boolean visible, String descriptor) {
        super(resolver);
        this.annot = new SymbolicAnnotationImpl(resolver, visible, descriptor);
        this.owner = owner;
    }

    @Override
    protected void acceptValue(String name, SymbolicValue v) {
        this.annot.addAttribute(name, v);
    }

    public void visitEnd() {
        this.owner.addAnnotation(this.annot);
    }

    static class TypeAnnotBuilderImpl
    extends SymbolicValueBuilder {
        private final TypeAnnotationReceiver owner;
        private final int typeRef;
        private final @Nullable TypePath path;
        private final SymbolicAnnotationImpl annot;

        TypeAnnotBuilderImpl(AsmSymbolResolver resolver, TypeAnnotationReceiver owner, int typeRef, @Nullable TypePath path, boolean visible, String descriptor) {
            super(resolver);
            this.owner = owner;
            this.typeRef = typeRef;
            this.path = path;
            this.annot = new SymbolicAnnotationImpl(resolver, visible, descriptor);
        }

        @Override
        protected void acceptValue(String name, SymbolicValue v) {
            this.annot.addAttribute(name, v);
        }

        public void visitEnd() {
            this.owner.acceptTypeAnnotation(this.typeRef, this.path, this.annot);
        }
    }
}

