/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.reporting.RuleContext;

public class CommentSizeRule
extends AbstractJavaRulechainRule {
    public static final PropertyDescriptor<Integer> MAX_LINES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxLines").desc("Maximum lines")).require(NumericConstraints.positive())).defaultValue((Object)6)).build();
    public static final PropertyDescriptor<Integer> MAX_LINE_LENGTH = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxLineLength").desc("Maximum line length")).require(NumericConstraints.positive())).defaultValue((Object)80)).build();

    public CommentSizeRule() {
        super(ASTCompilationUnit.class, new Class[0]);
        this.definePropertyDescriptor(MAX_LINES);
        this.definePropertyDescriptor(MAX_LINE_LENGTH);
    }

    public Object visit(ASTCompilationUnit cUnit, Object data) {
        for (JavaComment comment : cUnit.getComments()) {
            if (this.hasTooManyLines(comment)) {
                this.asCtx(data).addViolationWithPosition((Reportable)comment.getToken(), cUnit.getAstInfo(), comment.getReportLocation(), this.getMessage() + ": Too many lines", new Object[0]);
            }
            this.reportLinesTooLong(cUnit, this.asCtx(data), comment);
        }
        return null;
    }

    private static boolean hasRealText(Chars line) {
        return !JavaComment.removeCommentMarkup(line).isEmpty();
    }

    private boolean hasTooManyLines(JavaComment comment) {
        int firstLineWithText = -1;
        int lineNumberWithinComment = 0;
        int maxLines = (Integer)this.getProperty(MAX_LINES);
        for (Chars line : comment.getText().lines()) {
            if (CommentSizeRule.hasRealText(line)) {
                int lastLineWithText = lineNumberWithinComment;
                if (firstLineWithText == -1) {
                    firstLineWithText = lineNumberWithinComment;
                }
                if (lastLineWithText - firstLineWithText + 1 > maxLines) {
                    return true;
                }
            }
            ++lineNumberWithinComment;
        }
        return false;
    }

    private void reportLinesTooLong(ASTCompilationUnit acu, RuleContext ctx, JavaComment comment) {
        int maxLength = (Integer)this.getProperty(MAX_LINE_LENGTH);
        int lineNumber = comment.getReportLocation().getStartLine();
        for (Chars line : comment.getFilteredLines(true)) {
            if (line.length() > maxLength) {
                FileLocation location = FileLocation.caret((FileId)acu.getTextDocument().getFileId(), (int)lineNumber, (int)1);
                ctx.addViolationWithPosition((Reportable)comment.getToken(), acu.getAstInfo(), location, this.getMessage() + ": Line too long", new Object[0]);
            }
            ++lineNumber;
        }
    }
}

