/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.lang.reflect.Modifier;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UselessOverridingMethodRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> IGNORE_ANNOTATIONS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreAnnotations").defaultValue((Object)false)).desc("Ignore methods that have annotations (except @Override)")).build();

    public UselessOverridingMethodRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(IGNORE_ANNOTATIONS_DESCRIPTOR);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        OverloadSelectionResult overload;
        ASTMethodCall methodCall;
        if (!node.isOverridden() || node.getBody() == null || node.getModifiers().hasAny(JModifier.FINAL, JModifier.NATIVE, JModifier.SYNCHRONIZED) || JavaAstUtils.isCloneMethod(node)) {
            return null;
        }
        if (!((Boolean)this.getProperty(IGNORE_ANNOTATIONS_DESCRIPTOR)).booleanValue() && node.getDeclaredAnnotations().any(it -> !TypeTestUtil.isA(Override.class, (TypeNode)it))) {
            return null;
        }
        ASTStatement statement = ASTList.singleOrNull(node.getBody());
        if (statement == null) {
            return null;
        }
        if ((statement instanceof ASTExpressionStatement || statement instanceof ASTReturnStatement) && statement.getNumChildren() == 1 && statement.getChild(0) instanceof ASTMethodCall && (methodCall = (ASTMethodCall)statement.getChild(0)).getQualifier() instanceof ASTSuperExpression && methodCall.getArguments().size() == node.getArity() && JavaAstUtils.isUnqualifiedSuper(methodCall.getQualifier()) && !(overload = methodCall.getOverloadSelectionInfo()).isFailed() && overload.getMethodType().equals(node.getOverriddenMethod()) && this.sameModifiers(node.getOverriddenMethod().getSymbol(), (JMethodSymbol)node.getSymbol()) && this.argumentsAreUnchanged(node, methodCall)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return null;
    }

    private boolean argumentsAreUnchanged(ASTMethodDeclaration node, ASTMethodCall methodCall) {
        ASTArgumentList arg = methodCall.getArguments();
        int i = 0;
        for (ASTFormalParameter formal : node.getFormalParameters()) {
            if (!JavaAstUtils.isReferenceToVar((ASTExpression)arg.getChild(i), (JVariableSymbol)formal.getVarId().getSymbol())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean sameModifiers(JExecutableSymbol superMethod, JMethodSymbol subMethod) {
        int visibilityMask = 7;
        return (visibilityMask & subMethod.getModifiers()) == (visibilityMask & superMethod.getModifiers()) && !this.isProtectedElevatingVisibility(superMethod, subMethod);
    }

    private boolean isProtectedElevatingVisibility(JExecutableSymbol superMethod, JMethodSymbol subMethod) {
        return Modifier.isProtected(subMethod.getModifiers()) && !subMethod.getPackageName().equals(superMethod.getPackageName());
    }
}

