/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;

public class UseUtilityClassRule
extends AbstractJavaRulechainRule {
    private static final Set<String> IGNORED_CLASS_ANNOT = CollectionUtil.setOf((Object)"lombok.experimental.UtilityClass", (Object[])new String[]{"org.junit.runner.RunWith"});

    public UseUtilityClassRule() {
        super(ASTClassDeclaration.class, new Class[0]);
    }

    public Object visit(ASTClassDeclaration klass, Object data) {
        if (JavaAstUtils.hasAnyAnnotation(klass, IGNORED_CLASS_ANNOT) || TypeTestUtil.isA("junit.framework.TestSuite", (TypeNode)klass) || klass.isInterface() || klass.isAbstract() || klass.getSuperClassTypeNode() != null || klass.getSuperInterfaceTypeNodes().nonEmpty()) {
            return data;
        }
        boolean hasAnyMethods = false;
        boolean hasNonPrivateCtor = false;
        boolean hasAnyCtor = false;
        for (ASTBodyDeclaration declaration : klass.getDeclarations()) {
            if (declaration instanceof ASTFieldDeclaration && !((ASTFieldDeclaration)declaration).isStatic()) {
                return null;
            }
            if (declaration instanceof ASTConstructorDeclaration) {
                hasAnyCtor = true;
                if (((ASTConstructorDeclaration)declaration).getVisibility() != ModifierOwner.Visibility.V_PRIVATE) {
                    hasNonPrivateCtor = true;
                }
            }
            if (!(declaration instanceof ASTMethodDeclaration)) continue;
            if (((ASTMethodDeclaration)declaration).getVisibility() != ModifierOwner.Visibility.V_PRIVATE) {
                hasAnyMethods = true;
            }
            if (((ASTMethodDeclaration)declaration).isStatic()) continue;
            return null;
        }
        if (hasAnyMethods && (hasNonPrivateCtor |= !hasAnyCtor && klass.getVisibility() != ModifierOwner.Visibility.V_PRIVATE && !this.hasLombokPrivateCtor(klass))) {
            String message = "This utility class has a non-private constructor";
            this.asCtx(data).addViolationWithMessage((Node)klass, message);
        }
        return null;
    }

    private boolean hasLombokPrivateCtor(ASTClassDeclaration parent) {
        return parent.getDeclaredAnnotations().filter(t -> TypeTestUtil.isA("lombok.NoArgsConstructor", (TypeNode)t)).flatMap(ASTAnnotation::getMembers).filterMatching(ASTMemberValuePair::getName, (Object)"access").any(it -> UseUtilityClassRule.isAccessToVarWithName(it.getValue(), "PRIVATE"));
    }

    private static boolean isAccessToVarWithName(JavaNode node, String name) {
        return node instanceof ASTAssignableExpr.ASTNamedReferenceExpr && ((ASTAssignableExpr.ASTNamedReferenceExpr)node).getName().equals(name);
    }
}

