/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTEmptyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTResourceList;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class EmptyControlStatementRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> ALLOW_COMMENTED_BLOCKS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowCommentedBlocks").desc("Option for allowing empty but commented blocks. This is useful where a developer wants to have the code structure and explain why a condition does not require logic or to hold TODO comments for future work.")).defaultValue((Object)Boolean.FALSE)).build();

    public EmptyControlStatementRule() {
        super(ASTFinallyClause.class, ASTSynchronizedStatement.class, ASTTryStatement.class, ASTDoStatement.class, ASTBlock.class, ASTForStatement.class, ASTForeachStatement.class, ASTWhileStatement.class, ASTIfStatement.class, ASTSwitchStatement.class, ASTInitializer.class);
        this.definePropertyDescriptor(ALLOW_COMMENTED_BLOCKS);
    }

    public Object visit(ASTFinallyClause node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty finally clause");
        }
        return null;
    }

    public Object visit(ASTSynchronizedStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty synchronized statement");
        }
        return null;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        if (node.getNumChildren() == 1) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty switch statement");
        }
        return null;
    }

    public Object visit(ASTBlock node, Object data) {
        if (this.isEmpty(node) && node.getParent() instanceof ASTBlock) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty block");
        }
        return null;
    }

    public Object visit(ASTIfStatement node, Object data) {
        if (this.isEmpty(node.getThenBranch())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty if statement");
        }
        if (node.hasElse() && this.isEmpty(node.getElseBranch())) {
            this.asCtx(data).addViolationWithMessage((Node)node.getElseBranch(), "Empty else statement");
        }
        return null;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty while statement");
        }
        return null;
    }

    public Object visit(ASTForStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty for statement");
        }
        return null;
    }

    public Object visit(ASTForeachStatement node, Object data) {
        if (JavaRuleUtil.isExplicitUnusedVarName(node.getVarId().getName())) {
            return null;
        }
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty foreach statement");
        }
        return null;
    }

    public Object visit(ASTDoStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty do..while statement");
        }
        return null;
    }

    public Object visit(ASTInitializer node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty initializer statement");
        }
        return null;
    }

    public Object visit(ASTTryStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            boolean hasResource = false;
            ASTResourceList resources = node.getResources();
            if (resources != null) {
                for (ASTResource resource : resources) {
                    hasResource = true;
                    ASTLocalVariableDeclaration localVarDecl = resource.asLocalVariableDeclaration();
                    if (localVarDecl == null) {
                        ASTExpression init = resource.getInitializer();
                        if (!EmptyControlStatementRule.isSimpleExpression(init)) continue;
                        this.asCtx(data).addViolationWithMessage((Node)node, "Empty try-with-resources statement. Should be written {0}.close()", new Object[]{PrettyPrintingUtil.prettyPrint(init)});
                        return null;
                    }
                    ASTVariableId varId = (ASTVariableId)localVarDecl.getVarIds().firstOrThrow();
                    if (!varId.getLocalUsages().isEmpty()) {
                        return null;
                    }
                    String name = varId.getName();
                    if (JavaRuleUtil.isExplicitUnusedVarName(name)) continue;
                    this.asCtx(data).addViolationWithMessage((Node)node, "Empty try-with-resources statement. Rename the resource to `ignored`, `unused` or `_` (Java 22+).");
                    return null;
                }
            }
            if (!hasResource) {
                this.asCtx(data).addViolationWithMessage((Node)node, "Empty try body");
            }
        }
        return null;
    }

    private static boolean isSimpleExpression(ASTExpression init) {
        return init instanceof ASTThisExpression || init instanceof ASTSuperExpression || init instanceof ASTVariableAccess || init instanceof ASTFieldAccess && EmptyControlStatementRule.isSimpleExpression(((ASTFieldAccess)init).getQualifier());
    }

    private boolean isEmpty(JavaNode node) {
        boolean allowCommentedBlocks = (Boolean)this.getProperty(ALLOW_COMMENTED_BLOCKS);
        return node instanceof ASTBlock && node.getNumChildren() == 0 && (!((ASTBlock)node).containsComment() || !allowCommentedBlocks) || node instanceof ASTEmptyStatement;
    }
}

