/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.rule.internal.AbstractIgnoredAnnotationRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AtLeastOneConstructorRule
extends AbstractIgnoredAnnotationRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTClassDeclaration.class, (Class[])new Class[0]);
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Arrays.asList("lombok.Data", "lombok.Value", "lombok.Builder", "lombok.NoArgsConstructor", "lombok.RequiredArgsConstructor", "lombok.AllArgsConstructor");
    }

    public Object visit(ASTClassDeclaration node, Object data) {
        if (!node.isRegularClass() || node.isStatic() || node.getDeclarations().any(it -> it instanceof ASTConstructorDeclaration) || this.hasIgnoredAnnotation(node)) {
            return data;
        }
        NodeStream members = node.getDeclarations().filterIs(ModifierOwner.class).filterNot(it -> it instanceof ASTTypeDeclaration);
        if (members.isEmpty() || members.any(it -> !it.hasModifiers(JModifier.STATIC, new JModifier[0]))) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }
}

