/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.ant.Formatter;
import net.sourceforge.pmd.ant.RuleSetWrapper;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.ant.internal.PMDTaskImpl;
import net.sourceforge.pmd.lang.rule.RulePriority;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PMDTask
extends Task {
    private Path classpath;
    private Path auxClasspath;
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private final List<Path> relativizePathsWith = new ArrayList<Path>();
    private String suppressMarker;
    private String rulesetFiles;
    private String encoding;
    private int threads = 1;
    private int minimumPriority = RulePriority.LOW.getPriority();
    private int maxRuleViolations = 0;
    private String failuresPropertyName;
    private SourceLanguage sourceLanguage;
    private String cacheLocation;
    private boolean noCache;
    private final Collection<RuleSetWrapper> nestedRules = new ArrayList<RuleSetWrapper>();

    public void execute() throws BuildException {
        this.validate();
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(PMDTask.class.getClassLoader());
        try {
            PMDTaskImpl mirror = new PMDTaskImpl(this);
            mirror.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    private void validate() throws BuildException {
        if (this.formatters.isEmpty()) {
            Formatter defaultFormatter = new Formatter();
            defaultFormatter.setType("text");
            defaultFormatter.setToConsole(true);
            this.formatters.add(defaultFormatter);
        } else {
            for (Formatter f : this.formatters) {
                if (!f.isNoOutputSupplied()) continue;
                throw new BuildException("toFile or toConsole needs to be specified in Formatter");
            }
        }
        if (this.rulesetFiles == null) {
            if (this.nestedRules.isEmpty()) {
                throw new BuildException("No rulesets specified");
            }
            this.rulesetFiles = this.getNestedRuleSetFiles();
        }
    }

    private String getNestedRuleSetFiles() {
        StringBuilder sb = new StringBuilder();
        Iterator<RuleSetWrapper> it = this.nestedRules.iterator();
        while (it.hasNext()) {
            RuleSetWrapper rs = it.next();
            sb.append(rs.getFile());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public void setSuppressMarker(String suppressMarker) {
        this.suppressMarker = suppressMarker;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setFailOnRuleViolation(boolean fail) {
        this.failOnRuleViolation = fail;
    }

    public void setMaxRuleViolations(int max) {
        if (max >= 0) {
            this.maxRuleViolations = max;
            this.failOnRuleViolation = true;
        }
    }

    public void setRuleSetFiles(String ruleSets) {
        this.rulesetFiles = ruleSets;
    }

    public void setEncoding(String sourceEncoding) {
        this.encoding = sourceEncoding;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setFailuresPropertyName(String failuresPropertyName) {
        this.failuresPropertyName = failuresPropertyName;
    }

    public void setMinimumPriority(int minPriority) {
        this.minimumPriority = minPriority;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addFormatter(Formatter f) {
        this.formatters.add(f);
    }

    public void addConfiguredSourceLanguage(SourceLanguage version) {
        this.sourceLanguage = version;
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setAuxClasspath(Path auxClasspath) {
        this.auxClasspath = auxClasspath;
    }

    public Path getAuxClasspath() {
        return this.auxClasspath;
    }

    public Path createAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.getProject());
        }
        return this.auxClasspath.createPath();
    }

    public void setAuxClasspathRef(Reference r) {
        this.createAuxClasspath().setRefid(r);
    }

    public void addRuleset(RuleSetWrapper r) {
        this.nestedRules.add(r);
    }

    public List<Formatter> getFormatters() {
        return this.formatters;
    }

    public List<FileSet> getFilesets() {
        return this.filesets;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isFailOnRuleViolation() {
        return this.failOnRuleViolation;
    }

    public String getSuppressMarker() {
        return this.suppressMarker;
    }

    public String getRulesetFiles() {
        return this.rulesetFiles;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getMinimumPriority() {
        return this.minimumPriority;
    }

    public int getMaxRuleViolations() {
        return this.maxRuleViolations;
    }

    public String getFailuresPropertyName() {
        return this.failuresPropertyName;
    }

    public SourceLanguage getSourceLanguage() {
        return this.sourceLanguage;
    }

    public Collection<RuleSetWrapper> getNestedRules() {
        return this.nestedRules;
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    public void setCacheLocation(String cacheLocation) {
        this.cacheLocation = cacheLocation;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public void addRelativizePathsWith(Path relativizePathsWith) {
        this.relativizePathsWith.add(relativizePathsWith);
    }

    public List<Path> getRelativizePathsWith() {
        return this.relativizePathsWith;
    }
}

