/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.normalform;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class OWLObjectComplementOfExtractor
extends OWLClassExpressionVisitorAdapter {
    private final Set<OWLClassExpression> result = new HashSet<OWLClassExpression>();

    @Nonnull
    public Set<OWLClassExpression> getComplementedClassExpressions(@Nonnull OWLClassExpression desc) {
        this.reset();
        desc.accept((OWLClassExpressionVisitor)this);
        return new HashSet<OWLClassExpression>(this.result);
    }

    public void reset() {
        this.result.clear();
    }

    public void visit(OWLObjectAllValuesFrom ce) {
        ((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectComplementOf ce) {
        this.result.add(ce.getOperand());
        ce.getOperand().accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectExactCardinality ce) {
        ((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectIntersectionOf ce) {
        for (OWLClassExpression op : ce.getOperands()) {
            op.accept((OWLClassExpressionVisitor)this);
        }
    }

    public void visit(OWLObjectMaxCardinality ce) {
        ((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectMinCardinality ce) {
        ((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectSomeValuesFrom ce) {
        ((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitor)this);
    }

    public void visit(OWLObjectUnionOf ce) {
        for (OWLClassExpression op : ce.getOperands()) {
            op.accept((OWLClassExpressionVisitor)this);
        }
    }
}

