/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.metrics.IntegerValuedMetric;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.search.Searcher;

public class MaximumNumberOfNamedSuperclasses
extends IntegerValuedMetric {
    public MaximumNumberOfNamedSuperclasses(@Nonnull OWLOntology o) {
        super(o);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Maximum number of asserted named superclasses";
    }

    @Override
    public Integer recomputeMetric() {
        int count = 0;
        HashSet<OWLClass> processedClasses = new HashSet<OWLClass>();
        for (OWLOntology ont : this.getOntologies()) {
            for (OWLClass cls : ont.getClassesInSignature()) {
                assert (cls != null);
                if (processedClasses.contains(cls)) continue;
                processedClasses.add(cls);
                int curCount = 0;
                for (OWLClassExpression desc : Searcher.sup((Collection)ont.getSubClassAxiomsForSubClass(cls), OWLClassExpression.class)) {
                    if (desc.isAnonymous()) continue;
                    ++curCount;
                }
                if (curCount <= count) continue;
                count = curCount;
            }
        }
        return count;
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassOfAxiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMetric() {
    }
}

