/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.StringLengthComparator;

public class XMLWriterNamespaceManager {
    @Nonnull
    private final Map<String, String> prefixNamespaceMap = new TreeMap<String, String>((Comparator<String>)new StringLengthComparator());
    @Nonnull
    private final Map<String, String> namespacePrefixMap = new TreeMap<String, String>((Comparator<String>)new StringLengthComparator());
    @Nonnull
    private final Map<String, String> wellknownNamespaces = new TreeMap<String, String>((Comparator<String>)new StringLengthComparator());
    @Nonnull
    private String defaultNamespace;

    public XMLWriterNamespaceManager(@Nonnull String defaultNamespace) {
        this.defaultNamespace = (String)OWLAPIPreconditions.checkNotNull((Object)defaultNamespace, (String)"defaultNamespace cannot be null");
    }

    public void addWellKnownNamespace(@Nonnull String prefix, @Nonnull String namespace) {
        this.wellknownNamespaces.put((String)OWLAPIPreconditions.checkNotNull((Object)prefix, (String)"prefix cannot be null"), (String)OWLAPIPreconditions.checkNotNull((Object)namespace, (String)"namespace cannot be null"));
    }

    public void setPrefix(@Nonnull String prefix, @Nonnull String namespace) {
        OWLAPIPreconditions.checkNotNull((Object)prefix, (String)"prefix cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)namespace, (String)"namespace cannot be null");
        this.prefixNamespaceMap.put(prefix, namespace);
        this.namespacePrefixMap.put(namespace, prefix);
    }

    @Nullable
    public String getPrefixForNamespace(@Nonnull String namespace) {
        return this.namespacePrefixMap.get(OWLAPIPreconditions.checkNotNull((Object)namespace, (String)"namespace cannot be null"));
    }

    @Nullable
    public String getNamespaceForPrefix(@Nonnull String prefix) {
        return this.prefixNamespaceMap.get(OWLAPIPreconditions.checkNotNull((Object)prefix, (String)"prefix cannot be null"));
    }

    @Nullable
    public String getQName(@Nonnull String name) {
        OWLAPIPreconditions.checkNotNull((Object)name, (String)"name cannot be null");
        if (name.startsWith(this.defaultNamespace)) {
            return name.substring(this.defaultNamespace.length(), name.length());
        }
        for (Map.Entry<String, String> e : this.namespacePrefixMap.entrySet()) {
            if (!name.startsWith(e.getKey())) continue;
            String localName = name.substring(e.getKey().length(), name.length());
            return e.getValue() + ':' + localName;
        }
        return name;
    }

    @Nonnull
    public String getQName(@Nonnull IRI name) {
        if (name.getNamespace().equals(this.defaultNamespace)) {
            return name.prefixedBy("");
        }
        String candidate = this.namespacePrefixMap.get(name.getNamespace());
        if (candidate != null) {
            return name.prefixedBy(candidate + ':');
        }
        return name.toString();
    }

    public void createPrefixForNamespace(@Nonnull String namespace) {
        OWLAPIPreconditions.checkNotNull((Object)namespace, (String)"namespace cannot be null");
        if (namespace.equals(this.defaultNamespace)) {
            return;
        }
        String prefix = this.wellknownNamespaces.get(namespace);
        if (prefix != null) {
            this.setPrefix(prefix, namespace);
        }
        if (!this.namespacePrefixMap.containsKey(namespace)) {
            int counter = 1;
            while (this.prefixNamespaceMap.get("p" + counter) != null) {
                ++counter;
            }
            this.setPrefix("p" + counter, namespace);
        }
    }

    @Nonnull
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(@Nonnull String namespace) {
        this.defaultNamespace = (String)OWLAPIPreconditions.checkNotNull((Object)namespace, (String)"namespace cannot be null");
    }

    @Nonnull
    public Iterable<String> getPrefixes() {
        return this.prefixNamespaceMap.keySet();
    }

    @Nonnull
    public Iterable<String> getNamespaces() {
        return this.namespacePrefixMap.keySet();
    }

    @Nonnull
    public String getDefaultPrefix() {
        for (Map.Entry<String, String> e : this.prefixNamespaceMap.entrySet()) {
            if (e.getKey().isEmpty() || !e.getValue().equals(this.defaultNamespace)) continue;
            return e.getKey();
        }
        return "";
    }
}

