/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec;

import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.FipsKDF;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.KTSKeySpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

public class KTSExtractKeySpec
extends KTSKeySpec {
    private final PrivateKey privateKey;
    private final byte[] encapsulation;

    private KTSExtractKeySpec(PrivateKey privateKey, byte[] byArray, String string, int n, String string2, int n2, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier, byte[] byArray2) {
        super(string, n, string2, n2, algorithmParameterSpec, algorithmIdentifier, byArray2);
        this.privateKey = privateKey;
        this.encapsulation = byArray;
    }

    public byte[] getEncapsulation() {
        return Arrays.clone(this.encapsulation);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public static final class Builder {
        private final PrivateKey privateKey;
        private final String algorithmName;
        private final int keySizeInBits;
        private final byte[] encapsulation;
        private final byte[] otherInfo;
        private String macAlgorithm;
        private int macKeySizeInBits;
        private AlgorithmParameterSpec parameterSpec;
        private AlgorithmIdentifier kdfAlgorithm;

        public Builder(PrivateKey privateKey, byte[] byArray, String string, int n) {
            this(privateKey, byArray, string, n, null);
        }

        public Builder(PrivateKey privateKey, byte[] byArray, String string, int n, byte[] byArray2) {
            this.privateKey = privateKey;
            this.algorithmName = string;
            this.keySizeInBits = n;
            this.encapsulation = Arrays.clone(byArray);
            this.kdfAlgorithm = KTSKeySpec.createAlgId(KTSKeySpec.KDF3.withPRF(FipsKDF.AgreementKDFPRF.SHA256));
            this.otherInfo = KTSKeySpec.copyOtherInfo(byArray2);
        }

        public Builder withKdfAlgorithm(FipsKDF.AgreementKDFParametersBuilder agreementKDFParametersBuilder) {
            this.kdfAlgorithm = KTSKeySpec.createAlgId(agreementKDFParametersBuilder);
            return this;
        }

        public Builder withKdfAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
            this.kdfAlgorithm = algorithmIdentifier;
            return this;
        }

        public Builder withMac(String string, int n) {
            this.macAlgorithm = string;
            this.macKeySizeInBits = n;
            if (string != null && n <= 0) {
                throw new IllegalArgumentException("macKeySizeInBits must be greater than zero");
            }
            return this;
        }

        public Builder withParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            this.parameterSpec = algorithmParameterSpec;
            return this;
        }

        public KTSExtractKeySpec build() {
            return new KTSExtractKeySpec(this.privateKey, this.encapsulation, this.algorithmName, this.keySizeInBits, this.macAlgorithm, this.macKeySizeInBits, this.parameterSpec, this.kdfAlgorithm, this.otherInfo);
        }
    }
}

