/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.IvParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AuthenticationParametersWithIV;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.MACOperatorFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.ParametersWithIV;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.SymmetricKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.SEED;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.AuthParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseMac;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseWrapCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.EngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.GcmSpecUtil;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.IVAlgorithmParameterGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.IvAlgorithmParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.IvParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ParametersCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.SymmetricAlgorithmProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.Utils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.WrapParameterSpec;

class ProvSEED
extends SymmetricAlgorithmProvider {
    private SEED.OperatorFactory operatorFactory;
    private SEED.AEADOperatorFactory aeadOperatorFactory;
    private SEED.KeyWrapOperatorFactory keyWrapOperatorFactory;
    private static final String PREFIX = ProvSEED.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(final Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            if (parameters.getAlgorithm().equals(SEED.KW.getAlgorithm()) || parameters.getAlgorithm().equals(SEED.KWP.getAlgorithm())) {
                return new ParametersCreator(){

                    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        if (algorithmParameterSpec instanceof WrapParameterSpec) {
                            return ((SEED.WrapParameters)parameters).withUsingInverseFunction(((WrapParameterSpec)algorithmParameterSpec).useInverseFunction());
                        }
                        return parameters;
                    }
                };
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvSEED() {
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.aeadOperatorFactory = new SEED.AEADOperatorFactory();
            this.keyWrapOperatorFactory = new SEED.KeyWrapOperatorFactory();
            this.operatorFactory = new SEED.OperatorFactory();
        }
    }

    private SEED.OperatorFactory getGeneralOperatorFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        return this.operatorFactory;
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        final Class[] classArray = GcmSpecUtil.getCipherSpecClasses();
        final Class[] classArray2 = new Class[]{IvParameterSpec.class};
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.SEED", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgParams();
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "SEED", KISAObjectIdentifiers.id_seedCBC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator", KISAObjectIdentifiers.id_seedCBC, PREFIX + "$AlgParamGen", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "SEED", 16);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.SEED", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, SEED.ECBwithPKCS7, SEED.ECB, SEED.ECBwithISO10126_2, SEED.ECBwithISO7816_4, SEED.ECBwithTBC, SEED.ECBwithX923, SEED.CBC, SEED.CBCwithPKCS7, SEED.CBCwithISO10126_2, SEED.CBCwithISO7816_4, SEED.CBCwithTBC, SEED.CBCwithX923, SEED.CBCwithCS1, SEED.CBCwithCS2, SEED.CBCwithCS3, SEED.CFB128, SEED.CFB8, SEED.OFB, SEED.CTR, SEED.GCM, SEED.CCM, SEED.OCB, SEED.EAX).withGeneralOperators(ProvSEED.this.generalParametersCreatorProvider, ProvSEED.this.getGeneralOperatorFactory(), ProvSEED.this.aeadOperatorFactory).withParameters(classArray).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", KISAObjectIdentifiers.id_seedCBC, PREFIX + "$CBC", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, SEED.CBCwithPKCS7).withParameters(classArray2).withGeneralOperators(ProvSEED.this.generalParametersCreatorProvider, ProvSEED.this.getGeneralOperatorFactory(), null).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.SEEDWRAP", PREFIX + "$Wrap", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, SEED.KW).withGeneralOperators(ProvSEED.this.generalParametersCreatorProvider, ProvSEED.this.keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "SEEDWRAP", KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap);
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.SEEDKW", "SEEDWRAP");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.SEEDKWP", PREFIX + "$WrapWithPad", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, SEED.KWP).withGeneralOperators(ProvSEED.this.generalParametersCreatorProvider, ProvSEED.this.keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Alg.Alias.Cipher.SEEDWRAPPAD", "SEEDKWP");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.SEED", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "SEED", 128, true, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new SEED.KeyGenerator(secureRandom);
                    }
                });
            }
        }));
        bouncyCastleFipsProvider.addAlias("KeyGenerator", "SEED", KISAObjectIdentifiers.id_seedCBC, KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap, KISAObjectIdentifiers.id_seedMAC);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SEEDGMAC", PREFIX + "$GMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(SEED.GMAC, (MACOperatorFactory)new SEED.MACOperatorFactory(), new AuthParametersCreator(SEED.GMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "SEEDGMAC", "SEED-GMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SEEDCMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(SEED.CMAC, (MACOperatorFactory)new SEED.MACOperatorFactory(), new AuthParametersCreator(SEED.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "SEEDCMAC", "SEED-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.SEEDCCMMAC", PREFIX + "$SEEDCCMMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseMac(SEED.CCM, (MACOperatorFactory)new SEED.MACOperatorFactory(), new AuthParametersCreator((AuthenticationParametersWithIV)SEED.CCM.withMACSize(128)));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "SEEDCCMMAC", "SEED-CCMMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.SEED", PREFIX + "$SEEDKFACT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("SEED", SEED.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n != 128) {
                            throw new InvalidKeySpecException("Provided key data wrong size for SEED");
                        }
                        return byArray;
                    }
                });
            }
        }));
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "SEED IV";
        }
    }
}

