/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.pkcs.PBEParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.DigestAlgorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.PasswordBasedDeriver;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.PasswordConverter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.PBKD;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.AlgorithmProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.EngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.PBKDFPBEKey;

class ProvPBEPBKDF1
extends AlgorithmProvider {
    private static final String PREFIX = ProvPBEPBKDF1.class.getName();

    ProvPBEPBKDF1() {
    }

    public void configure(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.PBKDF1", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgParams();
            }
        }));
    }

    static byte[] getSecretKey(SecretKey secretKey, PBEParameterSpec pBEParameterSpec, DigestAlgorithm digestAlgorithm, PasswordBasedDeriver.KeyType keyType, int n) {
        PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(digestAlgorithm, secretKey.getEncoded()).withIterationCount(pBEParameterSpec.getIterationCount()).withSalt(pBEParameterSpec.getSalt()));
        return passwordBasedDeriver.deriveKey(keyType, (n + 7) / 8);
    }

    static byte[][] getSecretKeyAndIV(SecretKey secretKey, PBEParameterSpec pBEParameterSpec, DigestAlgorithm digestAlgorithm, PasswordBasedDeriver.KeyType keyType, int n, int n2) {
        PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(digestAlgorithm, secretKey.getEncoded()).withIterationCount(pBEParameterSpec.getIterationCount()).withSalt(pBEParameterSpec.getSalt()));
        return passwordBasedDeriver.deriveKeyAndIV(keyType, (n + 7) / 8, (n2 + 7) / 8);
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        PBEParameter params;

        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded("DER");
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == PBEParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return new PBEParameterSpec(this.params.getSalt(), this.params.getIterationCount().intValue());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF1 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            try {
                this.params = new PBEParameter(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException(exception.getMessage());
            }
        }

        protected void localInit(byte[] byArray) throws IOException {
            this.params = PBEParameter.getInstance(byArray);
        }

        protected String engineToString() {
            return "PBKDF1 Parameters";
        }
    }

    public static class FixedPBKDF1
    extends BaseKDFSecretKeyFactory {
        private final String algorithm;
        private final PasswordConverter passwordConverter;
        private final DigestAlgorithm prfAlg;
        private final int keySizeInBits;

        public FixedPBKDF1(String string, PasswordConverter passwordConverter, DigestAlgorithm digestAlgorithm, int n) {
            this.algorithm = string;
            this.passwordConverter = passwordConverter;
            this.prfAlg = digestAlgorithm;
            this.keySizeInBits = n;
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                if (pBEKeySpec.getSalt() == null) {
                    throw new InvalidKeySpecException("Missing required salt");
                }
                PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PBKDF1.using(this.prfAlg, this.passwordConverter, pBEKeySpec.getPassword()).withSalt(pBEKeySpec.getSalt()).withIterationCount(pBEKeySpec.getIterationCount()));
                return new PBKDFPBEKey(passwordBasedDeriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, (this.keySizeInBits + 7) / 8), this.algorithm, pBEKeySpec);
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }
}

