/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECPrivateKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ECUtil;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ProvKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvECPrivateKey
implements ECPrivateKey,
ProvKey<AsymmetricECPrivateKey> {
    static final long serialVersionUID = 994553197664784084L;
    private transient AsymmetricECPrivateKey baseKey;

    ProvECPrivateKey(Algorithm algorithm, ECPrivateKey eCPrivateKey) {
        ECDomainParameters eCDomainParameters = ECUtil.convertFromSpec(eCPrivateKey.getParams());
        this.baseKey = new AsymmetricECPrivateKey(algorithm, eCDomainParameters, eCPrivateKey.getS());
    }

    ProvECPrivateKey(Algorithm algorithm, ECPrivateKeySpec eCPrivateKeySpec) {
        this.baseKey = new AsymmetricECPrivateKey(algorithm, ECUtil.convertFromSpec(eCPrivateKeySpec.getParams()), eCPrivateKeySpec.getS());
    }

    ProvECPrivateKey(AsymmetricECPrivateKey asymmetricECPrivateKey) {
        this.baseKey = asymmetricECPrivateKey;
    }

    @Override
    public AsymmetricECPrivateKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return ECUtil.convertToSpec(this.baseKey.getDomainParameters());
    }

    @Override
    public BigInteger getS() {
        return this.baseKey.getS();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvECPrivateKey)) {
            return false;
        }
        ProvECPrivateKey provECPrivateKey = (ProvECPrivateKey)object;
        return this.baseKey.equals(provECPrivateKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("EC Private Key").append(string);
        try {
            stringBuilder.append("    S: ").append(this.getS().toString(16)).append(string);
        }
        catch (Exception exception) {
            stringBuilder.append("RESTRICTED").append(string);
        }
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricECPrivateKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

