/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.spec.ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricDSTU4145PublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.interfaces.DSTU4145PublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.DSTU4145Util;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ECUtil;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.provider.ProvKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.DSTU4145ParameterSpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.jcajce.spec.DSTU4145PublicKeySpec;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvDSTU4145PublicKey
implements DSTU4145PublicKey,
ProvKey<AsymmetricDSTU4145PublicKey> {
    private static final long serialVersionUID = 7026240464295649314L;
    private transient AsymmetricDSTU4145PublicKey baseKey;

    ProvDSTU4145PublicKey(Algorithm algorithm, DSTU4145PublicKey dSTU4145PublicKey) {
        DSTU4145ParameterSpec dSTU4145ParameterSpec = dSTU4145PublicKey.getParams();
        this.baseKey = new AsymmetricDSTU4145PublicKey(algorithm, DSTU4145Util.convertToECParams(dSTU4145ParameterSpec), ECUtil.convertPoint(dSTU4145ParameterSpec, dSTU4145PublicKey.getW()));
    }

    ProvDSTU4145PublicKey(Algorithm algorithm, DSTU4145PublicKeySpec dSTU4145PublicKeySpec) {
        DSTU4145ParameterSpec dSTU4145ParameterSpec = dSTU4145PublicKeySpec.getParams();
        this.baseKey = new AsymmetricDSTU4145PublicKey(algorithm, DSTU4145Util.convertToECParams(dSTU4145ParameterSpec), ECUtil.convertPoint(dSTU4145ParameterSpec, dSTU4145PublicKeySpec.getW()));
    }

    ProvDSTU4145PublicKey(AsymmetricDSTU4145PublicKey asymmetricDSTU4145PublicKey) {
        this.baseKey = asymmetricDSTU4145PublicKey;
    }

    @Override
    public AsymmetricDSTU4145PublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public DSTU4145ParameterSpec getParams() {
        return DSTU4145Util.convertToECSpec(this.baseKey.getParameters());
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.baseKey.getW().getAffineXCoord().toBigInteger(), this.baseKey.getW().getAffineYCoord().toBigInteger());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Strings.lineSeparator();
        stringBuilder.append("DSTU4145 Public Key").append(string);
        stringBuilder.append("    X: ").append(this.baseKey.getW().getAffineXCoord().toBigInteger().toString(16)).append(string);
        stringBuilder.append("    Y: ").append(this.baseKey.getW().getAffineYCoord().toBigInteger().toString(16)).append(string);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvDSTU4145PublicKey)) {
            return false;
        }
        ProvDSTU4145PublicKey provDSTU4145PublicKey = (ProvDSTU4145PublicKey)object;
        return this.baseKey.equals(provDSTU4145PublicKey.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricDSTU4145PublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

