/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.dvcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.dvcs.Data;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.dvcs.TargetEtcChain;
import net.snowflake.client.jdbc.internal.org.bouncycastle.dvcs.DVCSConstructionException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.dvcs.DVCSRequestData;
import net.snowflake.client.jdbc.internal.org.bouncycastle.dvcs.TargetChain;

public class VPKCRequestData
extends DVCSRequestData {
    private List chains;

    VPKCRequestData(Data data) throws DVCSConstructionException {
        super(data);
        TargetEtcChain[] certs = data.getCerts();
        if (certs == null) {
            throw new DVCSConstructionException("DVCSRequest.data.certs should be specified for VPKC service");
        }
        this.chains = new ArrayList(certs.length);
        for (int i = 0; i != certs.length; ++i) {
            this.chains.add(new TargetChain(certs[i]));
        }
    }

    public List getCerts() {
        return Collections.unmodifiableList(this.chains);
    }
}

