/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal;

import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.CryptoServicesRegistrar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BlockCipherMode {
    ECB("ECB", false),
    CBC("CBC", true),
    CBCMAC("CBCMAC", false),
    CFB8("CFB8", true),
    CFB16("CFB16", true),
    CFB32("CFB32", true),
    CFB64("CFB64", true),
    CFB128("CFB128", true),
    CFB256("CFB256", true),
    OFB8("OFB8", true),
    OFB16("OFB16", true),
    OFB32("OFB32", true),
    OFB64("OFB64", true),
    OFB128("OFB128", true),
    OFB256("OFB256", true),
    CTR("CTR", true),
    GCM("GCM", true),
    CCM("CCM", true),
    OCB("OCB", true),
    EAX("EAX", true),
    GOSTMAC("MAC", false),
    CMAC("CMAC", false),
    GMAC("GMAC", true),
    WRAP("WRAP", false),
    WRAPPAD("WRAPPAD", false),
    RFC3217_WRAP("RFC3217WRAP", false),
    RFC3211_WRAP("RFC3211WRAP", true),
    OpenPGPCFB("OPENPGPCFB", false),
    GCFB("GCFB", true),
    GOFB("GOFB", true),
    CFB8MAC("CFB8MAC", false),
    ISO9797alg3("ISO979ALG3", false);

    private final String code;
    private final boolean expectsIV;

    private BlockCipherMode(String string2, boolean bl) {
        this.code = string2;
        this.expectsIV = bl;
    }

    public String getCode() {
        return this.code;
    }

    public static BlockCipherMode getMode(Algorithm algorithm) {
        return null;
    }

    public boolean expectsIV() {
        return this.expectsIV;
    }

    public byte[] createDefaultIV(int n, SecureRandom secureRandom) {
        byte[] byArray;
        switch (this) {
            case CCM: {
                byArray = new byte[n - 4];
                break;
            }
            case OCB: {
                byArray = new byte[n - 1];
                break;
            }
            default: {
                byArray = new byte[n];
            }
        }
        if (secureRandom != null) {
            secureRandom.nextBytes(byArray);
        } else {
            CryptoServicesRegistrar.getSecureRandom().nextBytes(byArray);
        }
        return byArray;
    }
}

