/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410KeyGenerationParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410PrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general.Gost3410PublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.KeyGenerationParameters;

class Gost3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private Gost3410KeyGenerationParameters param;

    Gost3410KeyPairGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (Gost3410KeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        Gost3410Parameters gost3410Parameters = this.param.getParameters();
        SecureRandom secureRandom = this.param.getRandom();
        BigInteger bigInteger2 = gost3410Parameters.getQ();
        BigInteger bigInteger3 = gost3410Parameters.getP();
        BigInteger bigInteger4 = gost3410Parameters.getA();
        while ((bigInteger = new BigInteger(256, secureRandom)).equals(ZERO) || bigInteger.compareTo(bigInteger2) >= 0) {
        }
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger, bigInteger3);
        return new AsymmetricCipherKeyPair(new Gost3410PublicKeyParameters(bigInteger5, gost3410Parameters), new Gost3410PrivateKeyParameters(bigInteger, gost3410Parameters));
    }
}

