/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.general;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DSA;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECAlgorithms;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECConstants;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECMultiplier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.FixedPointCombMultiplier;

class EcGost3410Signer
implements DSA {
    EcKeyParameters key;
    SecureRandom random;

    EcGost3410Signer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (!(cipherParameters instanceof ParametersWithRandom)) throw new IllegalArgumentException("No random provided where one required.");
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            this.key = (EcPrivateKeyParameters)parametersWithRandom.getParameters();
            return;
        } else {
            this.key = (EcPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        ECPoint eCPoint;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = byArray[byArray2.length - 1 - i];
        }
        BigInteger bigInteger4 = new BigInteger(1, byArray2);
        EcDomainParameters ecDomainParameters = this.key.getParameters();
        BigInteger bigInteger5 = ecDomainParameters.getN();
        BigInteger bigInteger6 = ((EcPrivateKeyParameters)this.key).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        while ((bigInteger3 = new BigInteger(bigInteger5.bitLength(), this.random)).equals(ECConstants.ZERO) || (bigInteger2 = (eCPoint = eCMultiplier.multiply(ecDomainParameters.getG(), bigInteger3).normalize()).getAffineXCoord().toBigInteger().mod(bigInteger5)).equals(ECConstants.ZERO) || (bigInteger = bigInteger3.multiply(bigInteger4).add(bigInteger6.multiply(bigInteger2)).mod(bigInteger5)).equals(ECConstants.ZERO)) {
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = byArray[byArray2.length - 1 - i];
        }
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        BigInteger bigInteger4 = this.key.getParameters().getN();
        if (bigInteger.compareTo(ECConstants.ONE) < 0 || bigInteger.compareTo(bigInteger4) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ECConstants.ONE) < 0 || bigInteger2.compareTo(bigInteger4) >= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger3.modInverse(bigInteger4);
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger5).mod(bigInteger4);
        BigInteger bigInteger7 = bigInteger4.subtract(bigInteger).multiply(bigInteger5).mod(bigInteger4);
        ECPoint eCPoint2 = this.key.getParameters().getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger6, eCPoint = ((EcPublicKeyParameters)this.key).getQ(), bigInteger7).normalize();
        if (eCPoint3.isInfinity()) {
            return false;
        }
        BigInteger bigInteger8 = eCPoint3.getAffineXCoord().toBigInteger().mod(bigInteger4);
        return bigInteger8.equals(bigInteger);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

