/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips.RsaCoreEngine;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.DataLengthException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.RsaKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.RsaPrivateCrtKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.BigIntegers;

class RsaBlindedEngine
implements AsymmetricBlockCipher {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RsaCoreEngine core = new RsaCoreEngine();
    private RsaKeyParameters key;
    private SecureRandom random;

    RsaBlindedEngine() {
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.core.init(bl, cipherParameters);
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.key = (RsaKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            this.key = (RsaKeyParameters)cipherParameters;
            if (this.key.isPrivate()) {
                throw new IllegalArgumentException("No random provided where one required.");
            }
        }
    }

    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) {
        BigInteger bigInteger;
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        BigInteger bigInteger2 = this.core.convertInput(byArray, n, n2);
        if (bigInteger2.compareTo(this.key.getModulus()) >= 0) {
            throw new DataLengthException("input to RSA engine out of range");
        }
        if (this.key instanceof RsaPrivateCrtKeyParameters) {
            RsaPrivateCrtKeyParameters rsaPrivateCrtKeyParameters = (RsaPrivateCrtKeyParameters)this.key;
            BigInteger bigInteger3 = rsaPrivateCrtKeyParameters.getPublicExponent();
            if (bigInteger3 != null) {
                BigInteger bigInteger4;
                BigInteger bigInteger5 = rsaPrivateCrtKeyParameters.getModulus();
                BigInteger bigInteger6 = BigIntegers.createRandomInRange(ONE, bigInteger5.subtract(ONE), this.random);
                BigInteger bigInteger7 = bigInteger6.modPow(bigInteger3, bigInteger5).multiply(bigInteger2).mod(bigInteger5);
                BigInteger bigInteger8 = this.core.processBlock(bigInteger7);
                bigInteger = bigInteger8.multiply(bigInteger4 = bigInteger6.modInverse(bigInteger5)).mod(bigInteger5);
                if (!bigInteger2.equals(bigInteger.modPow(bigInteger3, bigInteger5))) {
                    throw new IllegalStateException("RSA engine faulty decryption/signing detected");
                }
            } else {
                bigInteger = this.core.processBlock(bigInteger2);
            }
        } else {
            bigInteger = this.core.processBlock(bigInteger2);
        }
        return this.core.convertOutput(bigInteger);
    }
}

