/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.IllegalKeyException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.BasicAgreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DhParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.MqvPrivateParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.MqvPublicParameters;

class MqvBasicAgreement
implements BasicAgreement {
    MqvPrivateParameters privParams;

    MqvBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.privParams = (MqvPrivateParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        MqvPublicParameters mqvPublicParameters = (MqvPublicParameters)cipherParameters;
        DhPrivateKeyParameters dhPrivateKeyParameters = this.privParams.getStaticPrivateKey();
        if (!this.privParams.getStaticPrivateKey().getParameters().equals(mqvPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalKeyException("MQV public key components have wrong domain parameters");
        }
        if (this.privParams.getStaticPrivateKey().getParameters().getQ() == null) {
            throw new IllegalKeyException("MQV key domain parameters do not have Q set");
        }
        BigInteger bigInteger = this.calculateMqvAgreement(dhPrivateKeyParameters.getParameters(), dhPrivateKeyParameters, mqvPublicParameters.getStaticPublicKey(), this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), mqvPublicParameters.getEphemeralPublicKey());
        if (bigInteger.equals(BigInteger.ONE)) {
            throw new IllegalStateException("1 is not a valid agreement value for MQV");
        }
        return bigInteger;
    }

    private BigInteger calculateMqvAgreement(DhParameters dhParameters, DhPrivateKeyParameters dhPrivateKeyParameters, DhPublicKeyParameters dhPublicKeyParameters, DhPrivateKeyParameters dhPrivateKeyParameters2, DhPublicKeyParameters dhPublicKeyParameters2, DhPublicKeyParameters dhPublicKeyParameters3) {
        BigInteger bigInteger = dhParameters.getQ();
        int n = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = BigInteger.valueOf(2L).pow(n);
        BigInteger bigInteger3 = dhPublicKeyParameters2.getY().mod(bigInteger2).add(bigInteger2);
        BigInteger bigInteger4 = dhPrivateKeyParameters2.getX().add(bigInteger3.multiply(dhPrivateKeyParameters.getX())).mod(bigInteger);
        BigInteger bigInteger5 = dhPublicKeyParameters3.getY().mod(bigInteger2).add(bigInteger2);
        BigInteger bigInteger6 = dhPublicKeyParameters3.getY().multiply(dhPublicKeyParameters.getY().modPow(bigInteger5, dhParameters.getP())).modPow(bigInteger4, dhParameters.getP());
        return bigInteger6;
    }
}

