/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.IllegalKeyException;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.BasicAgreement;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.CipherParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;

class EcDhBasicAgreement
implements BasicAgreement {
    EcPrivateKeyParameters key;

    EcDhBasicAgreement() {
    }

    public void init(CipherParameters cipherParameters) {
        this.key = (EcPrivateKeyParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        EcPublicKeyParameters ecPublicKeyParameters = (EcPublicKeyParameters)cipherParameters;
        if (!ecPublicKeyParameters.getParameters().equals(this.key.getParameters())) {
            throw new IllegalKeyException("ECDH public key has wrong domain parameters");
        }
        ECPoint eCPoint = ecPublicKeyParameters.getQ().multiply(this.key.getD()).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

