/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric;

import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.ASN1OctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.DEROctetString;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X962Parameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ECPoint;
import net.snowflake.client.jdbc.internal.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.Algorithm;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.AsymmetricPublicKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.asymmetric.KeyUtils;
import net.snowflake.client.jdbc.internal.org.bouncycastle.math.ec.ECPoint;

public final class AsymmetricECPublicKey
extends AsymmetricECKey
implements AsymmetricPublicKey {
    private final ECPoint q;

    public AsymmetricECPublicKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, byte[] byArray) {
        super(algorithm, eCDomainParametersID);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve().decodePoint(byArray));
    }

    public AsymmetricECPublicKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, byte[] byArray) {
        super(algorithm, eCDomainParameters);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve().decodePoint(byArray));
    }

    public AsymmetricECPublicKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, ECPoint eCPoint) {
        super(algorithm, eCDomainParametersID);
        this.q = KeyUtils.validated(eCPoint);
    }

    public AsymmetricECPublicKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, ECPoint eCPoint) {
        super(algorithm, eCDomainParameters);
        this.q = KeyUtils.validated(eCPoint);
    }

    public AsymmetricECPublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricECPublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, subjectPublicKeyInfo.getAlgorithm());
        DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
        X9ECPoint x9ECPoint = new X9ECPoint(this.getDomainParameters().getCurve(), dEROctetString);
        this.q = KeyUtils.validated(x9ECPoint.getPoint());
    }

    public byte[] getEncoded() {
        ECDomainParameters eCDomainParameters = this.getDomainParameters();
        X962Parameters x962Parameters = KeyUtils.buildCurveParameters(eCDomainParameters);
        ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(new X9ECPoint(this.getW()).toASN1Primitive());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), aSN1OctetString.getOctets());
        return KeyUtils.getEncodedInfo(subjectPublicKeyInfo);
    }

    public ECPoint getW() {
        return this.q;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECPublicKey)) {
            return false;
        }
        AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)object;
        if (!this.q.equals(asymmetricECPublicKey.q)) {
            return false;
        }
        return this.getDomainParameters().equals(asymmetricECPublicKey.getDomainParameters());
    }

    public int hashCode() {
        int n = this.q.hashCode();
        n = 31 * n + this.getDomainParameters().hashCode();
        return n;
    }
}

